<?php

namespace App\Http\Requests\Backend\Documents;

use Illuminate\Foundation\Http\FormRequest;

class UpdateDocumentsRequest extends FormRequest
{


    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => ['required', 'max:191'],
            'url' => ['string', 'nullable', 'url'],
        ];
    }

    /**
     * Show the Messages for rules above.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'name.required' => 'File Name field is required.',
            'name.max' => 'File Name  may not be greater than 191 character.',
        ];
    }
}
