<?php

namespace App\Http\Responses\Backend\Websites;

use Illuminate\Contracts\Support\Responsable;

class EditResponse implements Responsable
{
    /**
     * @var \App\Models\Website\Website
     */
    protected $website;

    /**
     * @param \App\Models\Website\Website $website
     */
    public function __construct($website)
    {
        $this->website = $website;
    }

    /**
     * toReponse.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        return view('backend.websites.edit')->with([
            'website' => $this->website,
        ]);
    }
}
