<?php

namespace App\Models\Auth\Traits\Relationships;

use App\Models\Auth\PasswordHistory;
use App\Models\Auth\Permission;
use App\Models\Auth\Role;
use App\Models\Auth\SocialAccount;
use App\Models\Category;
use App\Models\Link;

trait UserRelationships
{
    /**
     * @return mixed
     */
    public function providers()
    {
        return $this->hasMany(SocialAccount::class);
    }

    /**
     * @return mixed
     */
    public function passwordHistories()
    {
        return $this->hasMany(PasswordHistory::class);
    }

    /**
     * @return mixed
     */
    // public function sessions()
    // {
    //     return $this->hasMany(Session::class);
    // }

    /**
     * Many-to-Many relations with Role.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function roles()
    {
        return $this->belongsToMany(Role::class, 'role_user');
    }

    /**
     * Many-to-Many relations with Permission.
     * ONLY GETS PERMISSIONS ARE NOT ASSOCIATED WITH A ROLE.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function permissions()
    {
        return $this->belongsToMany(Permission::class);
    }
 

    public function categories()
    {
        return $this->belongsToMany(Category::class,'doc_category_user')
                    ->whereNull('url')
                    ->withPivot('permissions');
    }
    public function documents()
    {
        return $this->belongsToMany(Category::class,'doc_category_user')->whereNotNull('url') ->withPivot('permissions');
    }
    public function link()
    {
        return $this->belongsTo(Link::class,'user_id');
    }
}
