<?php

namespace App\Models;

use App\Models\Traits\Attributes\CategoryAttributes;
use App\Models\Traits\ModelAttributes;
use App\Models\Traits\Relationships\CategoryRelationships;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends BaseModel
{
    use SoftDeletes, ModelAttributes, CategoryRelationships, CategoryAttributes;

    protected $table = "doc_categories";
    /**
     * The guarded field which are not mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * Fillable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'serial_number',
        'version',
        'status',
        'url',
        'size',
        'size_s3',
        'expire_date',
        'parent_category_id',
        'created_by',
        'updated_by',
    ];
    const VIEW = 0;
    const CREATE = 1;
    const EDIT = 2;
    const DELETE = 4;
    const SHARE= 8;
    const FULLPERMISSION =15;// VIEW|CREATE|EDIT|DELETE|SHARE

    function tempUrl() {
        if($this->url==Null)
        return "#";
        return route('local.temp',['url'    => 'uploads/'.$this->url]);
    }
}
