<?php

namespace App\Models\Traits;

use App\Models\Category;

trait ModelAttributes
{
    /**
     * @return string
     */
    public function getEditButtonAttribute($permission, $route,$id)
    {
        if (access()->allow($permission) || $permission==Category::EDIT) {
            return '<a href="'.route($route, $id?$id:$this).'" data-toggle="tooltip" data-placement="top" title="'.trans('buttons.general.crud.edit').'" class="btn" target="_blank" rel="noopener noreferrer">
                        <i class="fas fa-edit" ></i>
                    </a>';
        }
    }

    /**
     * @return string
     */
    public function getDeleteButtonAttribute($permission, $route,$id)
    {
        if (access()->allow($permission) || $permission==Category::DELETE) {
            return '<a href="'.route($route, $id?$id:$this).'"
                    class="btn"
                    data-method="delete"
                    data-trans-button-cancel="'.trans('buttons.general.cancel').'"
                    data-trans-button-confirm="'.trans('buttons.general.crud.delete').'"
                    data-trans-title="'.trans('strings.backend.general.are_you_sure').'">
                        <i data-toggle="tooltip" data-placement="top" title="'.trans('buttons.general.crud.delete').'" class="fa fa-trash"></i>
                </a>';
        }
    }
}
