<?php

namespace App\Services;

use App\Models\Category;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use ZipArchive;

class ZipService
{
    public static function createZip($categoryId)
    {
        $category = Category::find($categoryId);

        if (!$category) {
            throw new \Exception("Category with ID $category->name not found.");
        }

        $zip = new ZipArchive;

        $zipFileName = storage_path('app') . '/' . $category->name . '.zip';


        if ($zip->open($zipFileName, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== true) {
            throw new \Exception("Failed to create zip file.");
        }

        self::addCategoryToZip($category, '', $zip);
        $zip->close();

        return $zipFileName;
    }

    protected static function addCategoryToZip($category, $prefix, $zip)
    {
        $documents = Category::whereNotNull('url')->where('parent_category_id',$category->id)->get();

        foreach ($documents as $document) {
            $filePath = storage_path('app/uploads/' . $document->url);
            if (file_exists($filePath)) {
                $pathInfo = pathinfo($filePath);
                $zip->addFile($filePath, $prefix . '/' . $document->name.'('.$document->serial_number.')'. '.' . $pathInfo['extension']);
            } else {
                throw new \Exception("Document file not found:  $document->name($document->serial_number) ");
            }
        }
        foreach ($category->childern_categories as $childCategory) {
            $isSubfolder = strpos($prefix, '/' . $childCategory->name . '/') !== false;

            if (!$isSubfolder) {
                $subfolderName = $prefix . '/' . $childCategory->name;
                $zip->addEmptyDir($subfolderName);
                self::addCategoryToZip($childCategory, $subfolderName, $zip);
            }
        }
    }
    public static function createFolder($categoryId)
    {
        $category = Category::find($categoryId);

        if (!$category) {
            throw new \Exception("Category with ID $category->name not found.");
        }

        $tempFolderPath = storage_path('app/temp/' . $category->name);
        if (File::exists($tempFolderPath)) {
            File::deleteDirectory($tempFolderPath);
        }

        mkdir($tempFolderPath, 0777, true);

        self::addCategoryToFolder($category, $tempFolderPath);

        return $tempFolderPath;
    }

    protected static function addCategoryToFolder($category, $folderPath)
    {
        $documents = Category::whereNotNull('url')->where('parent_category_id', $category->id)->get();

        foreach ($documents as $document) {
            $filePath = storage_path('app/uploads/' . $document->url);
            if (file_exists($filePath)) {
                $pathInfo = pathinfo($filePath);
                $newFilePath = $folderPath . '/' . $document->name . '(' . $document->serial_number . ').' . $pathInfo['extension'];
                copy($filePath, $newFilePath);
            } else {
                throw new \Exception("Document file not found:  $document->name($document->serial_number) ");
            }
        }

        foreach ($category->childern_categories as $childCategory) {
            $childFolderPath = $folderPath . '/' . $childCategory->name;
            if (!file_exists($childFolderPath)) {
                mkdir($childFolderPath, 0777, true);
            }
            self::addCategoryToFolder($childCategory, $childFolderPath);
        }
    }


    public static function addFolderToZip($folderPath, $prefix, $zip)
    {
        $folder = opendir($folderPath);

        $zip->addEmptyDir($prefix);

        while (false !== ($item = readdir($folder))) {
            if ($item == '.' || $item == '..') {
                continue;
            }

            $itemPath = $folderPath . '/' . $item;

            if (is_file($itemPath)) {
                $zip->addFile($itemPath, $prefix . '/' . $item);
            }

            if (is_dir($itemPath)) {
                $zip->addEmptyDir($prefix . '/' . $item);
                self::addFolderToZip($itemPath, $prefix . '/' . $item, $zip);
            }
        }

        closedir($folder);
    }


    public static function emptyTempFolder()
    {
        $tempFolderPath = storage_path('app/temp');
        if (File::exists($tempFolderPath)) {
            File::deleteDirectory($tempFolderPath);
            File::makeDirectory($tempFolderPath);
        }
    }
}
