(function () {

    FTX.Logs = {

        list: {

            selectors: {
                log_table: $('#logs-table'),
                datatables_params: $('meta[name="datatables-params"]'),
            },

            init: function () {

                this.selectors.log_table.dataTable({

                    processing: false,
                    serverSide: true,
                    serverSide: true,
                    ajax: {
                        url: this.selectors.log_table.data('ajax_url'),
                        type: 'post',
                        data: {
                            model: new URLSearchParams(window.location.search).get('model'),
                            action: new URLSearchParams(window.location.search).get('action'),
                            record: new URLSearchParams(window.location.search).get('record'),
                            user_id: new URLSearchParams(window.location.search).get('user_id'),
                            from: new URLSearchParams(window.location.search).get('from'),
                            to: new URLSearchParams(window.location.search).get('to')
                        },
                    },
                    columns: [
                        { data: 'model', name: 'model' },
                        { data: 'action', name: 'action' },
                        { data: 'record_id', name: 'record_id' },
                        { data: 'label', name: 'label' },
                        { data: 'user', name: 'user'},
                        { data: 'created_at', name: 'created_at' },
                        { data: 'description', name: 'description', searchable: false, sortable: false }
                    ],
                    order: [[5, "asc"]],
                    searchDelay: 500,
                    "createdRow": function (row, data, dataIndex) {
                        FTX.Utils.dtAnchorToForm(row);
                    },
                    initComplete: function () {
                        var table = this.api().table();
                        var searchRow = $('<tr />').prependTo($(table.header()));

                        table.columns().every(function (index) {
                            var column = this;
                            var title = $(column.header()).text();


                            var inputContainer = $('<th />').appendTo(searchRow);
                            var input = $('<input type="text" />')
                                .appendTo(inputContainer)
                                .on('keyup change', function () {
                                    if (column.search() !== this.value) {
                                        column.search(this.value).draw();
                                    }
                                });

                            inputContainer.addClass('position-relative');
                            input.addClass('w-100');

                            var maxLength = 20;
                            var truncatedTitle = title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
                            input.attr('placeholder', truncatedTitle);
                        });
                    }
                });
            }
        },
        edit: {
            selectors: {
                model: jQuery(".model"),
                action: jQuery(".action"),
                user: jQuery(".user"),
                record: jQuery(".record"),
                getrecordsURL: "",
            },

            init: function (locale) {
                this.addHandlers(locale);
                FTX.tinyMCE.init(locale);
            },
            addHandlers: function (locale) {
                this.selectors.model.select2({
                    width: '100%',
                    placeholder: 'Select Model',
                    allowClear: true
                });
                this.selectors.action.select2({
                    width: '100%',
                    placeholder: 'Select Action',
                    allowClear: true
                });
                this.selectors.record.select2({
                    width: '100%',
                    placeholder: 'Select Record',
                    allowClear: true
                });
                this.selectors.user.select2({
                    width: '100%',
                    placeholder: 'Select User',
                    allowClear: true
                });
                this.selectors.model.on('change', function(e) {
                    var getrecordsURL = FTX.Logs.edit.selectors.getrecordsURL;
                    var searchURL = FTX.Logs.edit.selectors.searchURL;
                    $('.record').empty();
                    var model = $(this).val();

                    $.ajax({
                        url:getrecordsURL,
                        dataType: 'JSON',
                        data: {
                            model: model,
                        }
                    })
                    .done(function(data) {
                        $('.record').empty();

                        $('.record').append(
                            '<option  value=""> Select Record</option>');

                        $.each(data, function(index, value) {
                            $('.record').append(
                                '<option value="' + data[index].id + '">' + data[index]
                                .text + '</option>'
                            );
                        });

                        $('.record').trigger('change');
                    })
                    .fail(function(e) {
                        console.log("Error:" + JSON.stringify(e));
                    });

                });
            },
        },
    }
})();
