<?php

namespace App\Http\Controllers\Backend\Categories;

use ZipArchive;
use Carbon\Carbon;
use App\Models\Log;
use App\Models\Category;
use App\Models\Document;
use App\Models\Auth\Role;
use App\Models\Auth\User;
use Illuminate\Support\Str;
use App\Services\ZipService;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use App\Http\Responses\ViewResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Storage;
use App\Http\Responses\RedirectResponse;
use Illuminate\Http\Request as HttpRequest;
use App\Repositories\Backend\DocumentsRepository;
use App\Repositories\Backend\CategoriesRepository;
use App\Http\Responses\Backend\Category\EditResponse;
use App\Http\Requests\Backend\Categories\ManageCategoryRequest;
use App\Models\Link;

class CategoriesController extends Controller
{
    /**
     * @var \App\Repositories\Backend\CategoriesRepository
     */
    protected $repository;

    /**
     * @param \App\Repositories\Backend\CategoriesRepository $repository
     */
    public function __construct(CategoriesRepository $repository)
    {
        $this->repository = $repository;
        View::share('js', ['categories']);
    }

    /**
     *
     *
     * @return \App\Http\Responses\ViewResponse
     */
    public function index(HttpRequest $request)
    {

       $link=Link::where('user_id', auth()->user()->id)->where('expired_at', '>=', date('Y-m-d H:i:s'))->first();
       $user = User::find(auth()->user()->id);
        if (!$link && $user->guest) {
            $categories = $user->categories->pluck('id');
            $documents  = $user->documents->pluck('id');
            if($categories)
            foreach ($categories as $cat) {
                $user->categories()->detach($cat);
            }if($documents)
            foreach ($documents as $doc) {
                $user->documents()->detach($doc);
            }
           if($user) $user->delete();

            Auth::logout();
              abort(401, 'Unauthorized');
          }
        $roots = Category::whereNull('parent_category_id')->get();
        $Users = [];
        $users = User::where('status',1)->get();
        foreach ($users as $user) {
            if(!$user->isAdministrator())
            $Users[$user->id] = $user->name;
        }
        $rootId=Category::whereNull('parent_category_id')->value('id');
        return new ViewResponse('backend.categories.index',['roots' => $roots,'users'=>$Users,'rootId'=>$rootId]);
    }

    /**
     * @param \Illuminate\Http\Request as HttpRequest $request
     *
     * @return \App\Http\Responses\ViewResponse
     */
    public function create(HttpRequest $request)
    {
        $Category = Category::whereNull('url')->get();
        $Categories= Category:: getItems($Category,'name');
        $parentcategory = $request->get('categoryid');
        return new ViewResponse('backend.categories.create', ['Categories' => $Categories,'parentcategory'=>$parentcategory]);
    }

    /**
     * @param \Illuminate\Http\Request as HttpRequest $request
     *
     * @return \App\Http\Responses\RedirectResponse
     */
    public function store(HttpRequest $request)
    {
        $this->repository->create($request->except(['_token', '_method']));

        return new RedirectResponse(route('admin.categories.index'), ['flash_success' => __('alerts.backend.categories.created')]);
    }

    /**
     * @param $Categoryid
     * @param \Illuminate\Http\Request as HttpRequest $request
     *
     * @return \App\Http\Responses\Backend\Blog\EditResponse
     */
    public function edit( $Categoryid, HttpRequest $request)
    {
        $Category = Category::find( $Categoryid);
        $category = Category::whereNull('url')->get();
        $Categories= Category:: getItems($category,'name');
        return new EditResponse($Category, $Categories);
    }

    /**
     * @param $Categoryid
     * @param \Illuminate\Http\Request as HttpRequest $request
     *
     * @return \App\Http\Responses\RedirectResponse
     */
    public function update($Categoryid, HttpRequest $request)
    {
        $Category = Category::find( $Categoryid);
        $this->repository->update($Category, $request->except(['_token', '_method']));
        if(Auth()->user()->guest==1){
            return new RedirectResponse(route('admin.categories.index'), ['flash_success' => __('alerts.backend.categories.updated')]);
        }
        return new RedirectResponse(route('admin.categories.index',['categoryid' => $request->get('categories')]), ['flash_success' => __('alerts.backend.categories.updated')]);
    }

    /**
     * @param $Categoryid
     * @param \Illuminate\Http\Request as HttpRequest $request
     *
     * @return \App\Http\Responses\RedirectResponse
     */
    public function destroy($Categoryid, HttpRequest $request)
    {
        $Category = Category::find( $Categoryid);
        $this->repository->delete($Category);

        return new RedirectResponse(route('admin.categories.index',['categoryid' => $request->get('categories')]), ['flash_success' => __('alerts.backend.categories.deleted')]);
    }


    function tree(HttpRequest $request){
        $id = $request->get('id');
        $rootId=Category::whereNull('parent_category_id')->whereNull('url')->value('id');
        $userCategories = auth()->user()->categories->pluck('id')->toArray();
        $filteredCategories = auth()->user()->categories->filter(function ($category) use ($userCategories) {
            return !in_array($category->parent_category_id, $userCategories);
        });
        $filteredCategoryIds = $filteredCategories->pluck('id')->toArray();
        return response()->json(Category::whereNull('url')->where(function ($query) use ($id,$rootId,$filteredCategoryIds) {
            if ($id == null || $id == '#') {
                if(auth()->user()->categories->contains('id', $rootId))
                {
                    $query->where('parent_category_id', $rootId);
                }else
                $query->whereIn('id', $filteredCategoryIds);
            } else {
                $query->where('parent_category_id', $id);
            }
        })->get()->map(function ($cat) {
            return [
                'id' => $cat->id,
                'text' => $cat->name,
                'status'=>$cat->status,
                'children' => true,
                'data' => [
                'permissions' => User::getPermission(auth()->user(), $cat->id),
                ],
            ];
        })->values()->toArray());
    }

    public function checkUserCategory(HttpRequest $request)
{
    $userId = $request->input('userId');
    $categoryId = $request->input('categoryid');
    $permission = -1;
    $user = User::findOrFail($userId);
    if (User::hasAccess($user,$categoryId)) {
        $permission = User::getPermission($user,$categoryId);
    }
    if ($user->documents->contains('id', $categoryId)) {
        $permission=User::getPermission($user,$categoryId);
    }
    return response()->json($permission);
}
public function giveUserCategory(HttpRequest $request)
{
    $userId = $request->input('userId');
    $categoryId = $request->input('categoryid');
    $permission = $request->input('permissions');
        $category = Category::findOrFail($categoryId);
    $user = User::with('categories')->findOrFail($userId);
    if (!empty($permission)) {
        $permissions = array_sum($permission);
        if (!$user->categories->contains('id', $categoryId)) {
             $user->categories()->attach($categoryId, ['permissions' => $permissions]);
             $documents = Category::whereNotNull('url')->where('parent_category_id', $categoryId)->pluck('id');
             $categories= $user->categories()->where('parent_category_id', $categoryId)->pluck('categories.id');
             foreach ($categories as $catId) {
                if ($user->categories->contains('id', $catId)) {
                    $user->categories()->detach($catId);
                }
            }
             foreach ($documents as $documentId) {
                 if (!$user->documents->contains('id', $documentId)) {
                     $user->documents()->attach($documentId);
                 }
             }
            $des='';
            $create= Category::CREATE;
            $edit= Category::EDIT;
            $delete= Category::DELETE;
            $share= Category::SHARE;
            $FULL_PERMISSION = ($create | $edit | $delete |$share);
            $create_edit_delete = ($create | $edit | $delete );
            $create_edit_share= ($create | $edit  |$share);
            $create_delete_share = ($create  | $delete |$share);
            $edit_delete_share =( $edit | $delete |$share);
            $create_edit= ($create | $edit);
            $share_edit= ($share | $edit);
            $create_share= ($create | $share);
            $create_delete=($create | $delete);
            $share_delete=($share | $delete);
            $edit_delete =($edit | $delete);
            $create_document='';
            if ($permissions == $create || $permissions == $create_edit || $permissions == $create_delete || $permissions == $create_share
            || $permissions == $create_edit_share || $permissions == $create_delete_share || $permissions ==  $create_edit_delete || $permissions == $FULL_PERMISSION) {
                $des.=' , create';
                $create_document=' & create document';
            }
             if ($permissions == $edit || $permissions == $create_edit || $permissions == $edit_delete || $permissions == $share_edit
             || $permissions == $create_edit_share || $permissions ==  $create_edit_delete   || $permissions ==  $edit_delete_share  || $permissions == $FULL_PERMISSION ) {
                $des.=' , edit';
            }
            if ($permissions == $delete || $permissions == $create_delete || $permissions == $edit_delete || $permissions == $share_delete
            || $permissions ==  $create_edit_delete   || $permissions == $create_delete_share || $permissions ==  $edit_delete_share  || $permissions == $FULL_PERMISSION) {
                $des.=' , delete';
            }
            if ($permissions == $share || $permissions == $share_edit || $permissions == $create_share || $permissions == $share_delete
            || $permissions == $create_edit_share || $permissions == $create_delete_share  || $permissions ==  $edit_delete_share  || $permissions == $FULL_PERMISSION) {
               $des.=' , share';
           }
             $log_data = [
                'model' => 'Permission',
                'action' => 'Create', // Create, Update, Delete
                'user_id' => auth()->user()->id,
                'record_id' => $categoryId,
                'label' => $category->name.' ('.$user->name.')',
                'description' => 'The '.$category->name.' category has these permissions : view'.$des.' category'.$create_document .' for :('.$user->name.')',
            ];
            Log::create($log_data);
             return response()->json(['success' => true,'message'=>__('alerts.backend.categories.usercategory')]);
        }
    }

    return response()->json(['success' => false]);
}
public function search(HttpRequest $request)
{

    $term = trim($request->q);
    $name = $request->name;
    $categoryid=$request->categoryid;
    if (empty($term)) {
        return response()->json([]);
    }
    $Categories = [];
    $userCategories = auth()->user()->categories;
    $userCategoriesid = $userCategories->pluck('id')->toArray();
    $Categories = $userCategoriesid;
    foreach ($userCategories as $userCategory) {
        $childIds = $userCategory->getAllChildIds();
        $Categories = array_merge($Categories, $childIds);
    }
    $cat = Category::whereNull('url')->where(function ($query) use ($term,$Categories) {
        $query->where('name', 'LIKE', '%' . $term . '%')
        ->whereIn('id',$Categories)
        ->where('parent_category_id','!=',null);
    })
    ->when(
        $categoryid,
        function ($query) use ($categoryid,$name) {
            $childern_categories=[];
            $childern_categories = Category::find($categoryid)->getAllChildIds();
            $query->where('name', '!=', $name)
            ->whereNotIn('id', $childern_categories);
        }
    )
    ->when(
        $name,
        function ($query) use ($name) {
            $query->where('name', '!=', $name);
        }
    )
    ->limit(7)->get();



    $map = $cat->map(function ($results) {
        $categoryPath = Category::getCategoryPath($results);

        $data["id"] = $results->id;
        $data["text"] = $results->name;
        $data["subtitle"] = Category::formatCategoryPath($categoryPath);
        return $data;
    });
    return response()->json($map->toArray());

}
public function getcategorypath(HttpRequest $request)
{
    $categoryid=$request->categoryid;
    $category =Category::whereNull('url')->where('id',$categoryid)->first();
    $categoryPath = Category::getCategoryPath($category);
    $path=Category::formatCategoryPath($categoryPath);
    return response()->json($path);
}
public function categorypermission(HttpRequest $request)
{
 $users= User::all();
 $category = $request->get('category_id');
 $usersWithAccess=[];
 foreach($users as $user)
 {
    if(User::hasAccess($user,$category))
    {
        $usersWithAccess[] = $user;

    }

 }
  return new ViewResponse('backend.categories.category_permission',['users' => $usersWithAccess,'category'=>$request->get('category_id')]);
}
public function deletecategoryuser(HttpRequest $request)
{
    $userId = $request->input('user_id');
    $categoryId = $request->input('category_id');
    $user = User::findOrFail($userId);
    $user->categories()->detach($categoryId);
    $documents = Category::whereNotNull('url')->where('parent_category_id', $categoryId)->pluck('id');
    foreach ($documents as $documentId) {
            $user->documents()->detach($documentId);
    }
    $category= Category::find($categoryId);
    $log_data = [
        'model' => 'Permission',
        'action' => 'Delete', // Create, Update, Delete
        'user_id' => auth()->user()->id,
        'record_id' => $categoryId,
        'label' => $category->name .' ('.$user->name.')',
        'description' => 'Permissions deleted from :('.$user->name.')',
    ];
    Log::create($log_data);
    return new RedirectResponse(route('admin.categorypermission',['category_id' => $categoryId]), ['flash_success' => __('alerts.backend.access.permissions.deletedcategory')]);
}
public function editUserCategory(HttpRequest $request)
{
    $userId = $request->input('userId');
    $categoryId = $request->input('categoryid');
    $permission = $request->input('permissions');
    $user = User::with('categories')->findOrFail($userId);
    if (!empty($permission)) {
        $permissions = array_sum($permission);
         $user->categories()->updateExistingPivot($categoryId, ['permissions' => $permissions]);
         $category= Category::find($categoryId);
            $des='';
            $create= Category::CREATE;
            $edit= Category::EDIT;
            $delete= Category::DELETE;
            $share= Category::SHARE;
            $FULL_PERMISSION = ($create | $edit | $delete |$share);
            $create_edit_delete = ($create | $edit | $delete );
            $create_edit_share= ($create | $edit  |$share);
            $create_delete_share = ($create  | $delete |$share);
            $edit_delete_share =( $edit | $delete |$share);
            $create_edit= ($create | $edit);
            $share_edit= ($share | $edit);
            $create_share= ($create | $share);
            $create_delete=($create | $delete);
            $share_delete=($share | $delete);
            $edit_delete =($edit | $delete);
            $create_document='';
            if ($permissions == $create || $permissions == $create_edit || $permissions == $create_delete || $permissions == $create_share
            || $permissions == $create_edit_share || $permissions == $create_delete_share || $permissions ==  $create_edit_delete || $permissions == $FULL_PERMISSION) {
                $des.=' , create';
                $create_document=' & create document';
            }
             if ($permissions == $edit || $permissions == $create_edit || $permissions == $edit_delete || $permissions == $share_edit
             || $permissions == $create_edit_share || $permissions ==  $create_edit_delete   || $permissions ==  $edit_delete_share  || $permissions == $FULL_PERMISSION ) {
                $des.=' , edit';
            }
            if ($permissions == $delete || $permissions == $create_delete || $permissions == $edit_delete || $permissions == $share_delete
            || $permissions ==  $create_edit_delete   || $permissions == $create_delete_share || $permissions ==  $edit_delete_share  || $permissions == $FULL_PERMISSION) {
                $des.=' , delete';
            }
            if ($permissions == $share || $permissions == $share_edit || $permissions == $create_share || $permissions == $share_delete
            || $permissions == $create_edit_share || $permissions == $create_delete_share  || $permissions ==  $edit_delete_share  || $permissions == $FULL_PERMISSION) {
               $des.=' , share';
           }
             $log_data = [
                'model' => 'Permission',
                'action' => 'Update', // Create, Update, Delete
                'user_id' => auth()->user()->id,
                'record_id' => $categoryId,
                'label' => $category->name.' ('.$user->name.')',
                'description' => 'The '.$category->name.' category changed its permissions to : view'.$des.' category'.$create_document .' for :('.$user->name.')',
            ];
            Log::create($log_data);
         return response()->json(['success' => true,'message'=>__('alerts.backend.categories.usercategoryupdate')]);

    }


    return response()->json(['success' => false]);
}
public function share(HttpRequest $request)  {
    $categoryId = $request->input('categoryid');
    $expiration=$request->input('expiration');
    $permission = $request->input('permissions');
    $document=Category::whereNotNull('url')->where('id',$categoryId)->first();
    $category=Category::whereNull('url')->where('id',$categoryId)->first();

    $randomNumber = mt_rand(10000, 99999);
    $password=mt_rand(100000, 999999);

       $user= User::create([
                'first_name' => 'User'.$randomNumber,
                'email' => 'user'.$randomNumber.'@example.com',
                'guest' => 1,
                'password' => bcrypt($password),
                'confirmation_code' => md5(uniqid(mt_rand(), true)),
                'confirmed' => true,
                'created_by' => auth()->user()->id,
                'updated_by' => null,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'uuid' => Str::uuid(),
        ]);

        $role = Role::where('name', 'Guest')->first();
        if (!$user->roles->contains('id', $role->id)) {
            $user->roles()->attach($role->id);
        }
        if (!empty($permission)) {
                $permissions = array_sum($permission);
            if($document)
            {
                $category=$document;
                if (!$user->documents->contains('id', $document->id)) {
                    $user->documents()->attach($document->id, ['permissions' => $permissions]);

                }
            }
            if($category)
            {
                if (!$user->categories->contains('id', $category->id)) {
                    $user->categories()->attach($category->id, ['permissions' => $permissions]);
                }
                $documents = Category::whereNotNull('url')->where('parent_category_id', $category->id)->pluck('id');
                $categories= $user->categories()->where('parent_category_id',  $category->id)->pluck('categories.id');
                foreach ($categories as $catId) {
                   if ($user->categories->contains('id', $catId)) {
                       $user->categories()->detach($catId);
                   }
               }
                foreach ($documents as $documentId) {
                    if (!$user->documents->contains('id', $documentId)) {
                        $user->documents()->attach($documentId, ['permissions' => $permissions]);
                    }
                }
                }
            }

        $signedUrl = URL::route('temporary.route', ['user' => $user->id,'expires'=>strtotime($expiration)]);

        Link::create([
         'user_id'=>$user->id,
         'expired_at' => $expiration,
         'url'=>$signedUrl
        ]);
        $log_data = [
            'model' => 'Permission',
            'action' => 'Share', // Create, Update, Delete
            'user_id' =>  auth()->user()->id,
            'record_id' => $categoryId,
            'label' => $category->name,
            'description' => 'The '.$category->name.'  shared with :'.$user->full_name,
        ];
        Log::create($log_data);
        return response()->json(['signedUrl' => $signedUrl]);

    }
    public function temporaryroute(HttpRequest $request) {
        $temporaryRoute = Link::where('user_id', $request->user)->where('expired_at', '>=', now())->first();

        if (!$temporaryRoute) {
            abort(401, 'Unauthorized');
        }
        $user=User::findorFail($request->user);
        access()->loginUsingId($user->id);

        return redirect()->route('admin.categories.index');
      }
      public function downloadCategory(HttpRequest $request)
      {
        try {
            $categoryId = $request->input('categoryid');
            $category = Category::findOrFail($categoryId);
            if (!is_null($category->url)) {
                $filePath = 'uploads/' . $category->url;
                return Storage::download($filePath);
            }

            $zipFileName = ZipService::createZip($categoryId);
            return response()->download($zipFileName)->deleteFileAfterSend(true);
        } catch (\Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
      }
      public function downloadMultipleFiles(HttpRequest $request)
      {
        try {
            $string = $request->input('Categoryids');
            $Categoryids = explode(",", $string);
            $zip = new ZipArchive;

            $zipFileName = storage_path('app') . '\download' . date('Ymd_His')  . '.zip';

            if ($zip->open($zipFileName, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== true) {
                throw new \Exception("Failed to create zip file.");
            }
            foreach ($Categoryids as $Categoryid) {
                $category = Category::findOrFail($Categoryid);
                if (!is_null($category->url)) {
                    $filePath = storage_path('app/uploads/' . $category->url);
                    if (file_exists($filePath)) {
                        $pathInfo = pathinfo($filePath);
                        $zip->addFile($filePath,  $category->name.'('.$category->serial_number.')'. '.' . $pathInfo['extension']);
                    }
                } else {
                    $nestedZipFileName = ZipService::createFolder($Categoryid);
                    ZipService::addFolderToZip($nestedZipFileName, $category->name, $zip);

                }
            }

            $zip->close();
            ZipService::emptyTempFolder();
            return response()->download($zipFileName)->deleteFileAfterSend(true);

        } catch (\Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
      }
    public function delete_files(HttpRequest $request)
    {
        $string = $request->input('Categoryids');
        $Categoryids = explode(",", $string);
        foreach($Categoryids as $Categoryid){
            $Category = Category::find( $Categoryid);
            if (!is_null($Category->url)) {
                DocumentsRepository::delete($Category);
            }
            else{
                $this->repository->delete($Category);
            }
        }
        return new RedirectResponse(route('admin.categories.index'), ['flash_success' => __('alerts.backend.categories.deleted')]);
    }
}
