<?php

namespace App\Http\Controllers\Backend\Logs;


use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Responses\ViewResponse;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Backend\LogsRepository;
use App\Http\Requests\Backend\Logs\ManageLogsRequest;
use App\Models\Auth\User;
use App\Models\Category;
use App\Models\Document;
use App\Models\Log;

class LogsController extends Controller
{
    /**
     * @var \App\Repositories\Backend\LogsRepository
     */
    protected $repository;

    /**
     * @param \App\Repositories\Backend\LogsRepository $Log
     */
    public function __construct(LogsRepository $repository)
    {
        $this->repository = $repository;
        View::share('js', ['logs']);
    }

    /**
     * @param \App\Http\Requests\Backend\Logs\ManageLogsRequest $request
     *
     * @return ViewResponse
     */
    public function index(ManageLogsRequest $request)
    {
        return new ViewResponse('backend.logs.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return redirect()->route('admin.logs.index');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


         return redirect()->route('admin.logs.index');

           return redirect()->route('admin.logs.index')->with( ['status'=> 'Error to add' , 'type' => 'danger'] );

    }

    /**
     * Display the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return redirect()->route('admin.logs.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

       return redirect()->route('admin.logs.index');

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request

     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
         return redirect()->route('admin.logs.index');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request , $id)
    {

        return redirect()->route('admin.logs.index');


    }
    public function managementFilter()
    {
        $models = [];
        $logs = Log::all()->unique('model');
        foreach ($logs as $log) {
            $models[$log->model] = $log->model;
        }
        $Allusers = [];
        $users = User::get();
        foreach ($users as $user) {
            $Allusers[$user->id] = $user->name;
        }
        return view('backend.logs.log_filter',['models'=>$models,'users'=>$Allusers]);
    }
    public function management(Request $request)
    {
        if($request->ajax()){

            $logs = Log::leftjoin('users', 'users.id', '=', 'doc_logs.user_id')
                  ->where(function($query) use($request){
                $model = $request->get('model');
                $action = $request->get('action');
                $record_id = $request->get('record');
                $user_id = $request->get('user_id');
                $from = $request->get('from');
                $to = $request->get('to');

                if(!empty($model)) $query->where('doc_logs.model',$model);
                if(!empty($action)) $query->where('doc_logs.action',$action);
                if(!empty($record_id)) $query->where('doc_logs.record_id',$record_id);
                if(!empty($user_id)) $query->where('doc_logs.user_id',$user_id);
                if(!empty($from)) $query->whereRaw('DATE(doc_logs.created_at) >= \''.$from.'\'');
                if(!empty($to)) $query->whereRaw('DATE(doc_logs.created_at) <= \''.$to.'\'');
            })->select('doc_logs.*','users.name AS user_name');
            return Datatables::of($logs)
            ->escapeColumns(['model','action','description','record_id','label'])
            ->addColumn('user', function ($logs) {
                return $logs->user_name;
            })
            ->editColumn('created_at', function ($logs) {
                return Carbon::parse($logs->created_at)->toDateTimeString();
            })
            ->make(true);
        }

        return view('backend.logs.report');
    }
    public function getRecords(Request $request)
    {
        $model = trim($request->model);
        if (empty($model)) {
            return response()->json([]);
        }

        $isAdmin = access()->user()->isAdministrator();

        if ($model == "Document") {
            $records = $isAdmin ? Category::whereNotNull('url')->select('name', 'id','serial_number')->get() : auth()->user()->documents;
        } elseif ($model == "Category") {
            $categories = auth()->user()->categories;

            $allCategories = collect([]);

            foreach ($categories as $category) {
                $allCategories->push($category);
                $allCategories = $allCategories->merge($category->getAllChilds());
            }
            $records = $isAdmin ? Category::whereNull('url')->select('name', 'id')->get() : $allCategories;
        }
        elseif ($model == "Permission") {
            $categories = auth()->user()->categories;
            $documents = auth()->user()->documents;
            $allCategories = collect([]);

            foreach ($categories as $category) {
                $allCategories->push($category);
                $allCategories = $allCategories->merge($category->getAllChilds());
            }

            $records = $allCategories->merge($documents);
        } else {
            return response()->json([]);
        }

        $file_name = $records->map(function ($result) {
            return [
                "id" => $result->id,
                "text" => $result->name .' '.$result->serial_number,
            ];
        });

        return response()->json($file_name);
    }
    public function getlog(Request $request)  {
        $categoryId = $request->input('categoryid');
        $logs = Log::where('record_id', $categoryId)->get();
        $activities = [];
        $category = Category::findOrfail($categoryId);
        $details = [
            'name' => $category->name,
            'url' => $category->tempUrl(),
            'id' => $category->id,
            'attachment' => Category::getPhotoType($category),
            'type' => $category->url ? Category::getType($category->url) : 'Folder',
            'size' => formatFileSize($category->size),
            'size_server' => formatFileSize($category->size_s3),
            'owner' => $category->owner ? $category->owner->full_name:'',
            'updater' =>$category->updater ?" by ". $category->updater->full_name:'',
            'createdat' => formatDate($category->created_at),
            'updatedat' => formatDate($category->updated_at),
            'location' => Category::formatCategoryPath(Category::getCategoryPath($category)),
          ];

        foreach ($logs as $log) {
            $user = User::find($log->user_id);
            if($user){
                $details['user_picture'] = $user->picture;
              $detail='<br>(<span style="color:#2319e1;font-size=11px;">'.$log->description.'</span>)<br>';
            if ($log->action == 'Create' && in_array($log->model, ['Category','Document'])) {
                $activities[] = [
                    'text' => trans('labels.backend.access.categories.table.createdby') .' '.$user->full_name,
                    'date' => formatDate($log->created_at),
                  ];
            }

            if ($log->action == 'Update' && in_array($log->model, ['Category','Document'])) {
                $activities[] = [
                    'text' => trans('labels.backend.access.categories.table.editedby') .' '.$user->full_name,
                    'date' => formatDate($log->created_at),
                  ];
            }
            if ($log->action == 'Share' ) {
                $activities[] = [
                    'text' => trans('labels.backend.access.categories.table.sharedby') .' '.$user->full_name,
                    'date' => formatDate($log->created_at),
                  ];
             }
            if ($log->action == 'Create' && $log->model=='Permission') {
                $activities[] = [
                    'text' => trans('labels.backend.access.categories.table.grantedby') .' '.$user->full_name,
                    'date' => formatDate($log->created_at),
                  ];
              }

            if ($log->action == 'Update'  && $log->model=='Permission') {
                $activities[] = [
                    'text' => trans('labels.backend.access.categories.permission').' '. trans('labels.backend.access.categories.table.editedby') .' '.$user->full_name,
                    'date' => formatDate($log->updated_at),
                  ];
            }
            if ($log->action == 'Delete'  && $log->model=='Permission') {
                $activities[] = [
                    'text' =>trans('labels.backend.access.categories.permission').' '.  trans('labels.backend.access.categories.table.removedby') .' '. $user->full_name,
                    'date' => formatDate($log->created_at),
                  ];
            }
        }
        }
        $data=[
            'activities'=>$activities,
            'details'=>$details
        ];
        return response()->json($data);

    }
}
