<?php

namespace App\Models\Auth;

use App\Models\Auth\Traits\Access\UserAccess;
use App\Models\Auth\Traits\Attributes\UserAttributes;
use App\Models\Auth\Traits\Methods\UserMethods;
use App\Models\Auth\Traits\Relationships\UserRelationships;
use App\Models\Auth\Traits\Scopes\UserScopes;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;

/**
 * Class User.
 */
class User extends BaseUser
{
    use HasApiTokens, Notifiable,
     //SoftDeletes,
     UserAttributes, UserScopes, UserAccess, UserRelationships,
      UserMethods;

    const ACCESS_TYPE_SYSTEM_PORTAL = 1;
    const ACCESS_TYPE_WORKFLOW_PORTAL = 2;
    const ACCESS_TYPE_ESS_PORTAL = 4;
    const ACCESS_TYPE_GLOBAL_DIRECTORY = 16;



    public function dataStores()
    {
        return $this->hasMany(DataStore::class);
    }

    public function multipleAccess()
    {
        return ($this->access_type & ($this->access_type - 1)) != 0;
    }
}
