<?php


namespace App\Notifications\Backend\Auth;

use App\Enums\IsReadNotificationEnum;
use App\Enums\NotificationType;
use App\Models\Auth\User;

abstract class Notification implements INotification
{

    public $saveToDataBase = true;

    /** @var BaseObject $model */
    protected $model;

    public function __construct($model = Null)
    {
        $this->model = $model;
    }

    public static function send(Notification $notification) : bool
    {

        $curlHandler = curl_init();
        $headers = [
            'Content-Type: application/json',
        ];
        $data = '?type=' . $notification->getNotificationType() . '&dataId=' . ($notification->model ? $notification->model->id : null);


        /** @var User $user */
        foreach ($notification->getUsers() as $user) {
            if($notification->saveToDataBase ){
                $notification->toDatabase($user);
            }
        }


        return true;
    }

    public function getData(): array
    {
        return [
            (object)[
                'key' => 'data',
                'value' => $this->getCustomData()
            ],
        ];
    }

    public function getUsers()
    {
        return User::whereIn('id', $this->getUsersId())
            ->get();
    }
    public function getTitle($user): string
    {
        return NotificationType::Labels($user->language)[$this->getNotificationType()];
    }
    public function toDatabase($user): void
    {
        $notification = new \App\Models\Notification();

        $notification->notifiable_id = $user->id;
        $notification->data = $this->getCustomData();
        $notification->description = $this->getDescription();
        $notification->is_read = IsReadNotificationEnum::no;
        $notification->data_id = $this->model ? $this->getDataId($this->model->id) : null;
        $notification->url = $this->url($this->model->id);
        $notification->read_at = Null;
        $notification->created_at = \Carbon\Carbon::parse(now()->format('Y-m-d H:i:s'));
        $notification->updated_at = \Carbon\Carbon::parse(now()->format('Y-m-d H:i:s'));
        $notification->save();
    }
}
