<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use App\Models\Document;
use Faker\Generator as Faker;

$factory->define(Document::class, function (Faker $faker) {
    return [
        'file_name' => $faker->name,
        'url'=>$faker->url,
        'category_id' => function () {
            return factory(Category::class)->create()->id;
        },
        'created_by' => function () {
            return factory(User::class)->state('active')->create()->id;
        },
    ];
});
