(function () {


    FTX.EmailSender = {
        list: {

            selectors: {
                emailBody: 'emailBody',
                sendEmailForm: '#sendEmailForm',
                sendEmailModal: '#sendEmailModal'
            },

            init: function () {
                console.log('init EmailSender');
                CKEDITOR.replace('emailBody', {
                    toolbar: 'Full'
                });
                // CKEDITOR.replace('emailBody', {
                //     toolbar: [
                //         {
                //             name: 'document',
                //             items: ['Source', '-', 'Save', 'NewPage', 'Preview', 'Print', '-', 'Templates']
                //         },
                //         {
                //             name: 'clipboard',
                //             items: ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo']
                //         },
                //         {
                //             name: 'editing',
                //             items: ['Find', 'Replace', '-', 'SelectAll', '-', 'SpellChecker', 'Scayt']
                //         },
                //         {
                //             name: 'forms',
                //             items: ['Form', 'Checkbox', 'Radio', 'TextField', 'Textarea', 'Select', 'Button', 'ImageButton', 'HiddenField']
                //         },
                //         '/',
                //         {
                //             name: 'basicstyles',
                //             items: ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '-', 'RemoveFormat']
                //         },
                //         {
                //             name: 'paragraph',
                //             items: ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'Blockquote', 'CreateDiv', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock', '-', 'BidiLtr', 'BidiRtl', 'Language']
                //         },
                //         {
                //             name: 'links',
                //             items: ['Link', 'Unlink', 'Anchor']
                //         },
                //         {
                //             name: 'insert',
                //             items: ['Image', 'Table', 'HorizontalRule', 'Smiley', 'SpecialChar', 'PageBreak', 'Iframe']
                //         },
                //         '/',
                //         {
                //             name: 'styles',
                //             items: ['Styles', 'Format', 'Font', 'FontSize']
                //         },
                //         {
                //             name: 'colors',
                //             items: ['TextColor', 'BGColor']
                //         },
                //         {
                //             name: 'tools',
                //             items: ['Maximize', 'ShowBlocks']
                //         }
                //     ]
                // });

                var self = this; // store the reference to this object

                $(document).on('submit', this.selectors.sendEmailForm, function(e) {
                    e.preventDefault(); // Prevent the default form submission

                    // Get the email body from the CKEditor instance
                    var emailBody = CKEDITOR.instances[self.selectors.emailBody].getData();

                    // Get the sendEmailUrl from meta tag
                    var sendEmailUrl  = $('meta[name=\'sendEmail-url\']').attr('content');

                    // Create a new FormData object
                    var formData = new FormData(this);
                    // Append the email body to the FormData object
                    formData.append('emailBody', emailBody);

                    // Send the form data to the server using fetch
                    fetch(sendEmailUrl , {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        },
                        body: formData
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            // If the response contains 'success' flag, show the Swal success modal
                            Swal.fire("Success!", "Your email has been sent successfully.", "success")
                                .then((result) => {
                                    // Refresh the page after the Swal modal is closed
                                    if (result.isConfirmed || result.dismiss === Swal.DismissReason.close) {
                                        location.reload();
                                    }
                                });
                            // Reset the form
                            $(self.selectors.sendEmailForm)[0].reset();
                            $(self.selectors.sendEmailModal).modal('hide');
                        } else {
                            $(self.selectors.sendEmailModal).modal('hide');
                        }
                    })
                    .catch((error) => {
                        // Handle any other errors
                        Swal.fire("Error!", "An unexpected error occurred.", "error")
                        .then((result) => {
                            // Refresh the page after the Swal modal is closed
                            if (result.isConfirmed || result.dismiss === Swal.DismissReason.close) {
                                location.reload();
                            }
                        });

                        console.error('Error:', error);
                        $(self.selectors.sendEmailModal).modal('hide');
                    });
                });
            }

        }
    }



})();
