(function () {

    FTX.Permissions = {

        list: {

            selectors: {
                permissions_table: $('#permissions-table'),
                usercategory_table: $('#usercategory-table')
            },

            init: function () {
                let myTable = this.selectors.usercategory_table;
                this.selectors.permissions_table.dataTable({

                    processing: false,
                    serverSide: true,

                    ajax: {
                        url: this.selectors.permissions_table.data('ajax_url'),
                        type: 'post',
                    },
                    columns: [
                        { data: 'name', name: 'permissions.name' },
                        { data: 'actions', name: 'actions', searchable: false, sortable: false }
                    ],
                    order: [[2, "asc"]],
                    searchDelay: 500,
                    "createdRow": function (row, data, dataIndex) {
                        FTX.Utils.dtAnchorToForm(row);
                    }
                });

                this.selectors.usercategory_table.DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: this.selectors.usercategory_table.data('ajax_url'),
                        type: 'POST',
                        data: function(d){
                            d.category_id= myTable.attr('data-category-id');
                        }
                    },

                    columns: [
                        { data: 'category', name: 'category' },
                        { data: 'user_name', name: 'user_name', sortable: false },
                        { data: 'actions', name: 'actions', searchable: false, sortable: false }

                    ],
                    order: [[1, 'asc']],
                    searchDelay: 500,
                    createdRow: function (row, data, dataIndex) {
                        FTX.Utils.dtAnchorToForm(row);
                    }
                });
            }
        }
    };
})();
