@extends('backend.layouts.app')

@section('title', app_name() . ' | '. __('labels.backend.access.usercategory.user_category'))


@section('content')
<div class="card">
    <div class="card-body">
        <div class="row mb-2">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    @lang('labels.backend.access.usercategory.user_category')
                </h4>
            </div>
            <!--col-->
        </div>
        <!--row-->
        <div class="row">


              @foreach ($users as $user)
              <div class="col-md-4 my-2" style="margin-left: 8rem !important;">
                <div class="card card2">
                  <div class="list list-item">
                      <img src="{{ $user->picture }}" class="img-card">
                      <div class="list-item-content">
                        <h4  @if(!$user->categories->contains('id', $category))style="color:grey;" @endif>{{$user->name}}</h4>
                      </div>
                      @if($user->categories->contains('id', $category))
                      <a href="{{ route('admin.deletecategoryuser',['category_id' => $category ,'user_id'=>$user->id ])}}" class="delete-button" data-method="delete" data-trans-button-cancel="{{trans('buttons.general.cancel')}}" data-trans-button-confirm="{{trans('buttons.general.crud.delete')}}" data-trans-title="{{trans('strings.backend.general.are_you_sure')}}">
                        <i data-toggle="tooltip" data-placement="top" title="{{ trans('buttons.general.crud.delete')}}" class="fa fa-times"></i>
                      </a>
                      <button class="btn edit-button editpermissioncategory" data-toggle="modal" data-target="#permissionModal" data-category="{{ $category }}" data-user="{{ $user->id }}" data-username="{{ $user->full_name }}"><i class="fas fa-edit "></i></button>
                      @endif
                    </div>

                </div>
              </div>
              @endforeach
          </div>
               <!--row-->
    </div>
    <!--card-body-->
</div>
@include('backend.categories.includes.permissionModal', [ 'edit' => 'yes'])

<!--card-->
@endsection

@section('pagescript')
<script>
     FTX.Utils.documentReady(function() {
        FTX.Categories.edit.init();
        FTX.Categories.edit.selectors.edituserCategoryURL = "{{ route('admin.editUserCategory') }}";
        FTX.Categories.edit.selectors.getuserCategoryURL = "{{ route('admin.checkUserCategory') }}";

    });
</script>
@endsection

@push('after-styles')

{{ style(asset('css/view.css')) }}

@endpush
