@extends('backend.layouts.app')

@section('title', __('labels.backend.access.documents.management') . ' | ' . __('labels.backend.access.documents.create'))



@section('content')
{{ Form::open(['route' => 'admin.documents.store', 'class' => 'form-horizontal', 'role' => 'form', 'method' => 'post', 'id' => 'create-permission', 'files' => true]) }}

    <div class="card">
        @include('backend.documents.form')
        @include('backend.components.footer-buttons', [ 'cancelRoute' => 'admin.categories.index' ])
    </div><!--card-->
    {{ Form::close() }}
@endsection
@section('pagescript')
<script>
    FTX.Utils.documentReady(function() {
        FTX.Documents.edit.selectors.getCategoryURL = "{{ route('admin.childrencategories.get') }}";
        FTX.Documents.edit.init("create");
    });
</script>
@endsection
