@extends('backend.layouts.app')

@section('title', app_name() . ' | '. __('labels.backend.access.logs.management'))


@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    @lang('labels.backend.access.logs.management')
                </h4>
            </div>
            <!--col-->
            <!--col-->
        </div>
        <!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table" id="logs-table" data-ajax_url="{{ route("admin.logs.get") }}">
                        <thead>
                            <tr>
                                <th>@lang('labels.backend.access.logs.table.model')</th>
                                <th>@lang('labels.backend.access.logs.table.action')</th>
                                <th>@lang('labels.backend.access.logs.table.record_id')</th>
                                <th>@lang('labels.backend.access.logs.table.label')</th>
                                <th>@lang('labels.backend.access.logs.table.user')</th>
                                <th>@lang('labels.backend.access.logs.table.datetime')</th>
                                <th>@lang('labels.backend.access.logs.table.description')</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
            <!--col-->
        </div>
        <!--row-->
    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection

@section('pagescript')
<script>
    FTX.Utils.documentReady(function() {
        FTX.Logs.list.init();
    });
</script>
@endsection
