<div class="card-body">
    <div class="row">
        <div class="col-sm-5">
            <h4 class="card-title mb-0">
                <?php echo e(__('labels.backend.access.categories.management')); ?>

                <small class="text-muted"><?php echo e((isset($category)) ? __('labels.backend.access.categories.edit') : __('labels.backend.access.categories.create')); ?></small>
            </h4>
        </div>
        <!--col-->
    </div>
    <!--row-->

    <hr>
    <?php echo e(Form::hidden('categoryid', isset($category) ?$category->id :'',['id' => 'categoryid'])); ?>


    <div class="row mt-4 mb-4">
        <div class="col">
            <div class="form-group row">
                <?php echo e(Form::label('name', trans('validation.attributes.backend.access.categories.name'), ['class' => 'col-md-2 from-control-label required'])); ?>


                <div class="col-md-10">
                    <?php echo e(Form::text('name', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.access.categories.name'), 'required' => 'required'])); ?>

                </div>
                <!--col-->
            </div>
            <!--form-group-->
            <div class="form-group row">
                <?php echo e(Form::label('categories', trans('validation.attributes.backend.access.categories.parent_category'), ['class' => 'col-md-2 from-control-label required'])); ?>


                <div class="col-md-10">
                    <?php if(!empty($selectedCategories)): ?>
                    <?php echo e(Form::hidden('parentcategory', isset($selectedCategories) ?$selectedCategories :'',['id' => 'parentcategory'])); ?>

                    <?php echo e(Form::select('categories', isset($selectedCategories) ?['' => 'Select Category'] +$Categories :['' => 'Select Category'] , null, ['class' => 'form-control categories1 box-size', 'data-placeholder' => trans('validation.attributes.backend.access.categories.parent_category') ])); ?>

                    <?php else: ?>
                    <?php echo e(Form::hidden('parentcategory', isset($parentcategory) ? $parentcategory:'',['id' => 'parentcategory'])); ?>

                    <?php echo e(Form::select('categories',isset($parentcategory) ?['' => 'Select Category'] +$Categories :['' => 'Select Category']  , null, ['class' => 'form-control categories1 box-size', 'data-placeholder' => trans('validation.attributes.backend.access.categories.parent_category')])); ?>

                    <?php endif; ?>
                </div>
                <!--col-->
            </div>
            <!--form-group-->


        </div>
        <!--col-->
    </div>
    <!--row-->
</div>
<!--card-body-->

<?php $__env->startSection('pagescript'); ?>
<script type="text/javascript">
    FTX.Utils.documentReady(function() {
        FTX.Categories.edit.init("<?php echo e(config('locale.languages.' . app()->getLocale())[1]); ?>");
    });
    $(function(){

        $('.categories1').select2({
            width: '100%',
            minimumInputLength: 2,
            allowClear: true,
            ajax: {
                url: "<?php echo e(route('admin.categories.search')); ?>",
                dataType: 'json',
                data: function(params) {
                    return {
                        q: params.term.trim(),
                        name:$('input[name="name"]').val(),
                        categoryid:$('input[name="categoryid"]').val()
                    };
                },
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                error: function(err) {
                    console.log(err);
                },
                cache: true
            },
            templateResult: function(data) {
                if (!data.subtitle) {
                    return data.text;
                }
                return $('<span>').html(data.text + '<br><small style="color:grey;">' + data.subtitle + '</small>');
            }
        });

        });
</script>
<?php $__env->stopSection(); ?>
<?php /**PATH D:\mbl\doc\resources\views/backend/categories/form.blade.php ENDPATH**/ ?>