<?php

namespace App\Http\Controllers\Backend\Microsoft;

use Illuminate\Http\Request;
use GuzzleHttp\Client;
use App\Models\Category;
use App\Models\Auth\User;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Responses\ViewResponse;
use Illuminate\Support\Facades\View;
use App\Http\Responses\RedirectResponse;
use Illuminate\Support\Facades\Response;
use App\Repositories\Backend\DocumentsRepository;
use Microsoft\Graph\Graph;
use Microsoft\Graph\Model;
use Microsoft\Graph\Http\GraphResponse;
use League\OAuth2\Client\Provider\GenericProvider;
use League\OAuth2\Client\Token\AccessToken;
use App\Models\Document;
use App\Models\Auth\Role;
use GuzzleHttp\Exception\ClientException;
use Illuminate\Support\Str;
use App\Services\ZipService;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request as HttpRequest;
use GuzzleHttp\Exception\RequestException;
use App\Models\Link;
class OpenfilesController extends Controller
{
    public function checkLicense(Request $request)
    {
        $accessToken = session('access_token');
        // Prepare the request URL to retrieve license details
        $licenseDetailsUrl = "https://graph.microsoft.com/v1.0/me/licenseDetails";

        // Prepare the request headers
        $headers = [
            'Authorization' => 'Bearer ' . $accessToken,
        ];

        // Initialize Guzzle Client
        $client = new Client();

        try {
            // Make a GET request to retrieve license details
            $response = $client->request('GET', $licenseDetailsUrl, [
                'headers' => $headers,
            ]);

            // Check if the request was successful
            if ($response->getStatusCode() === 200) {
                // Parse the response to extract license details
                $responseData = json_decode($response->getBody(), true);

                // Check if the user has any licenses assigned
                if (isset($responseData['value']) && count($responseData['value']) > 0) {
                    // User has at least one license assigned, call getCategory with $request and return its result
                    return $this->getCategory($request);
                } else {
                    // User does not have any licenses assigned, return message
                    return  [
                        'success' => false,
                        'message' =>'You should buy a license to use this feature.',
                    ];
                }
            } else {
                // Return an error message if the request was not successful
                return [
                    'success' => false,
                    'message' => 'Please Try Again',
                ];
            }
        } catch (RequestException $e) {
            // Handle any errors that occur during the request
            return false;
        }
    }


    public function getCategory(Request $request)
    {
        $categoryId = $request->input('fileId');

        $category = Category::findOrFail($categoryId);

        // Check if the category exists
        if (!$category) {
            return response()->json([
                'success' => false,
                'message' => 'Category not found. Unable to upload file.',
            ], 404);
        }

        // Check if the category has a valid URL
        if (is_null($category->url)) {
            return response()->json([
                'success' => false,
                'message' => 'Category URL is not available. Unable to upload file.',
            ], 400);
        }

        // Extract the file name from the category URL
        $fileName = basename($category->url);

        // Construct the file path using the category URL
        $filePath = storage_path('app/uploads/' . $category->url);

        // Upload the file to the folder
        return $this->uploadFileToFolder($fileName, $filePath);
    }

    public function uploadFileToFolder($fileName, $filePath)
{


    $accessToken = session('access_token');
    $graph = new Graph();
    $graph->setAccessToken($accessToken);




    $folderPath = '/drive/root:/';

    // Check if the file already exists in the folder
    $fileExistsResponse = $this->checkFileExists($accessToken, $fileName, $folderPath);

    if ($fileExistsResponse['success']) {
        // File already exists, retrieve the online link
        return $fileExistsResponse;
    } else {

        $fileContent = file_get_contents($filePath);

        // Prepare the upload URL
        $uploadUrl = "https://graph.microsoft.com/v1.0/me$folderPath/$fileName:/content";

        // Prepare the request headers
        $headers = [
            'Authorization' => 'Bearer ' . $accessToken,
            'Content-Type' => 'application/octet-stream',
        ];

        // Make a PUT request to upload the file
        $client = new Client();
        $response = $client->request('PUT', $uploadUrl, [
            'headers' => $headers,
            'body' => $fileContent,
        ]);

        // Check if the file was uploaded successfully
        if ($response->getStatusCode() === 201) {

            $responseData = json_decode($response->getBody(), true);
            $itemId = $responseData['id'];

            // Call the getFileOnlineLink function
            return $this->getFileOnlineLink($accessToken, $itemId);
        } else {
            // Return an error message
            return [
                'success' => false,
                'message' => 'Error uploading file.',
            ];
        }
    }
}

public function checkFileExists($accessToken, $fileName, $folderPath)
{
    // Prepare the request URL to check if the file exists
    $fileExistsUrl = "https://graph.microsoft.com/v1.0/me$folderPath$fileName";

    // Prepare the request headers
    $headers = [
        'Authorization' => 'Bearer ' . $accessToken,
    ];


    $client = new Client();
    try {
        $response = $client->request('GET', $fileExistsUrl, [
            'headers' => $headers,
        ]);
    } catch (RequestException $e) {

        $statusCode = $e->getResponse()->getStatusCode();
        if ($statusCode === 404) {
            // File not found
            return [
                'success' => false,
                'message' => 'File not found.',
            ];
        }
        // Other error occurred, handle accordingly
        return [
            'success' => false,
            'message' => 'Error: ' . $e->getMessage(),
        ];
    }

    // Check if the request was successful
    if ($response->getStatusCode() === 200) {

        $responseData = json_decode($response->getBody(), true);

        if (isset($responseData['name']) && $responseData['name'] === $fileName) {

            $webUrl = $responseData['webUrl'];
            return [
                'success' => true,
                'webUrl' => $webUrl,
            ];
        } else {
            // File not found in the response
            return [
                'success' => false,
                'message' => 'File not found in the response.',
            ];
        }
    }
}
    public function getFileOnlineLink($accessToken, $itemId)
{
    // Prepare the request URL to retrieve file details
    $fileDetailsUrl = "https://graph.microsoft.com/v1.0/me/drive/items/$itemId";

    // Prepare the request headers
    $headers = [
        'Authorization' => 'Bearer ' . $accessToken,
    ];

    $client = new Client();
    $response = $client->request('GET', $fileDetailsUrl, [
        'headers' => $headers,
    ]);

    // Check if the request was successful
    if ($response->getStatusCode() === 200) {
        // Parse the response to extract the webUrl property
        $responseData = json_decode($response->getBody(), true);
        $webUrl = $responseData['webUrl'];

            return [
                'success' => true,
                'webUrl' => $webUrl,
            ];

            } else {

            return [
                'success' => false,
                'message' => 'Error retrieving online link.',
            ];
        }
    }
}

