<?php

namespace App\Http\Controllers\Backend\Notifications;

use App\Enums\IsReadNotificationEnum;
use App\Models\Notification;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;


class NotificationController extends Controller
{
    private $index_view  = "notifications.index";
    private $model_instance  = Notification::class;

    public static function count()
    {
        $count =  \App\Models\Notification::whereNotNull('notifiable_id')
            ->where('is_read',IsReadNotificationEnum::no)
            ->where('notifiable_id',Auth::user()->id)
            ->count();
        return response()->json(array('count'=> $count), 200);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // get my notification
        $notifications = $this->model_instance::where('notifiable_id', '=', Auth::id())
            ->orderBy('created_at', SORT_DESC)
            ->get();

        return view($this->index_view , ['notifications' => $notifications]);
    }






}
