<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class DataStoreController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'type_storage' => 'required|string',
            'ftp_host' => 'nullable|string|required_if:type_storage,ftp',
            'ftp_port' => 'nullable|integer|required_if:type_storage,ftp',
            'ftp_username' => 'nullable|string|required_if:type_storage,ftp',
            'ftp_password' => 'nullable|string|required_if:type_storage,ftp',
        ]);

        DataStore::create([
            'user_id' => auth()->id(),
            'type_storage' => $request->type_storage,
            'ftp_host' => $request->ftp_host,
            'ftp_port' => $request->ftp_port,
            'ftp_username' => $request->ftp_username,
            'ftp_password' => $request->ftp_password,
        ]);

        return redirect()->back()->with('success', 'Data store configuration saved successfully.');
    }
}
