<?php

namespace App\Http\Responses\Backend\Category;

use Illuminate\Contracts\Support\Responsable;

class EditResponse implements Responsable
{
    /**
     * @var \App\Models\Category\Category
     */
    protected $category;

    protected $Categories;
    /**
     * @param \App\Models\Category\Category $category
     */
    public function __construct($category, $Categories)
    {
        $this->category = $category;
        $this->Categories = $Categories;
    }

    /**
     * toReponse.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
      $selectedCategories =$this->category->parent_category!=null? $this->category->parent_category->id:'';
        return view('backend.categories.edit')->with([
            'category' => $this->category,
            'Categories' => $this->Categories,
            'selectedCategories' => $selectedCategories,
        ]);
    }
}
