<?php

namespace App\Listeners\Backend\Categories;

/**
 * Class CategoryEventListener.
 */
class CategoryEventListener
{
    /**
     * @var string
     */
    private $history_slug = 'Category';

    /**
     * @param $event
     */
    public function onCreated($event)
    {
        history()->withType($this->history_slug)
            ->withEntity($event->page->id)
            ->withText('trans("history.backend.categories.created") <strong>'.$event->category->title.'</strong>')
            ->withIcon('plus')
            ->withClass('bg-green')
            ->log();
    }

    /**
     * @param $event
     */
    public function onUpdated($event)
    {
        history()->withType($this->history_slug)
            ->withEntity($event->category->id)
            ->withText('trans("history.backend.categories.updated") <strong>'.$event->category->title.'</strong>')
            ->withIcon('save')
            ->withClass('bg-aqua')
            ->log();
    }

    /**
     * @param $event
     */
    public function onDeleted($event)
    {
        history()->withType($this->history_slug)
            ->withEntity($event->category->id)
            ->withText('trans("history.backend.categories.deleted") <strong>'.$event->category->title.'</strong>')
            ->withIcon('trash')
            ->withClass('bg-maroon')
            ->log();
    }

    /**
     * Register the listeners for the subscriber.
     *
     * @param \Illuminate\Events\Dispatcher $events
     */
    public function subscribe($events)
    {
        $events->listen(
            \App\Events\Backend\Categories\CategoryCreated::class,
            'App\Listeners\Backend\Categories\CategoryEventListener@onCreated'
        );

        $events->listen(
            \App\Events\Backend\Categories\CategoryUpdated::class,
            'App\Listeners\Backend\Categories\CategoryEventListener@onUpdated'
        );

        $events->listen(
            \App\Events\Backend\Categories\CategoryDeleted::class,
            'App\Listeners\Backend\Categories\CategoryEventListener@onDeleted'
        );
    }
}
