<?php

namespace App\Models\Auth\Traits\Access;
use App\Models\Category;
use App\Models\Auth\Permission;

trait UserAccess
{
    /**
     * Checks if the user has a Role by its name or id.
     *
     * @param string $nameOrId Role name or id.
     *
     * @return bool
     */
    public function hasRole($nameOrId)
    {
        foreach ($this->roles as $role) {
            foreach ($role->permissions as $permission) {
                // Check by ID (if $permission is numeric) or by slug
                if ($permission->first_parent == 'Documents System' && ((is_numeric($nameOrId) && $permission->id == $nameOrId) ||
                    $permission->slug == $nameOrId
                )) {
                    return true;
                }
            }
        }


        return false;
    }
    /**
     * Checks to see if user has array of roles.
     *
     * All must return true
     *
     * @param  $roles
     * @param  $needsAll
     *
     * @return bool
     */
    public function hasRoles($roles, $needsAll = false)
    {
        return true;
        //If not an array, make a one item array
        if (! is_array($roles)) {
            $roles = [$roles];
        }

        //User has to possess all of the roles specified
        if ($needsAll) {
            $hasRoles = 0;
            $numRoles = count($roles);

            foreach ($roles as $role) {
                if ($this->hasRole($role)) {
                    $hasRoles++;
                }
            }

            return $numRoles == $hasRoles;
        }

        //User has to possess one of the roles specified
        foreach ($roles as $role) {
            if ($this->hasRole($role)) {
                return true;
            }
        }

        return false;
    }

    /**
     * Check if user has a permission by its name or id.
     *
     * @param string $nameOrId Permission name or id.
     *
     * @return bool
     */
    public function allow($nameOrId)
    {
        //  return true;
        // Update for this function due to issue of user custom permission

        //Check permissions directly tied to user
        /*    foreach ($this->permissions as $perm) {
            //First check to see if it's an ID
            if (is_numeric($nameOrId)) {
                if ($perm->id == $nameOrId) {
                    return true;
                }
            }

            //Otherwise check by name
            if ($perm->slug == $nameOrId && $perm->first_parent == 'Documents System') {
                return true;
            }
        }
    */

        foreach ($this->roles as $role) {
            foreach ($role->permissions as $permission) {
                // Check by ID (if $permission is numeric) or by slug
                if ($permission->first_parent == 'Documents System' && ((is_numeric($nameOrId) && $permission->id == $nameOrId) ||
                    $permission->slug == $nameOrId
                )) {
                    return true;
                }
            }
        }

        foreach ($this->categories as $category) {
            //First check to see if it's an ID
            if (is_numeric($nameOrId)) {
                if ($category->id == $nameOrId) {
                    return true;
                }
            }

            //Otherwise check by name
            if ($category->name == $nameOrId) {
                return true;
            }
        }
       /* foreach ($this->roles as $role) {
            // See if role has all permissions
            if ($role->all) {
                return true;
            }

            /*
             *
             * below code is commented due to issue of user custom permisssion
             * if this code is not commented then if user dont have permission of one module but role which is assigned to that user have that permission than allow() method return true
             *
             */

            // Validate against the Permission table
            /*foreach ($role->permissions as $perm) {

                // First check to see if it's an ID
                if (is_numeric($nameOrId)) {
                    if ($perm->id == $nameOrId) {
                        return true;
                    }
                }

                // Otherwise check by name
                if ($perm->name == $nameOrId) {
                    return true;
                }
            }*/
   //     }

        return false;
    }

    /**
     * Check an array of permissions and whether or not all are required to continue.
     *
     * @param  $permissions
     * @param  $needsAll
     *
     * @return bool
     */
    public function allowMultiple($permissions, $needsAll = false)
    {
        //If not an array, make a one item array
        if (! is_array($permissions)) {
            $permissions = [$permissions];
        }

        //User has to possess all of the permissions specified
        if ($needsAll) {
            $hasPermissions = 0;
            $numPermissions = count($permissions);

            foreach ($permissions as $perm) {
                if ($this->allow($perm)) {
                    $hasPermissions++;
                }
            }

            return $numPermissions == $hasPermissions;
        }

        //User has to possess one of the permissions specified
        foreach ($permissions as $perm) {
            if ($this->allow($perm)) {
                return true;
            }
        }

        return false;
    }

    /**
     * @param  $nameOrId
     *
     * @return bool
     */
    public function hasPermission($nameOrId)
    {
        return $this->allow($nameOrId);
    }
  /**
     * @param  $nameOrId
     *
     * @return bool
     */
    public function hasCategory($nameOrId)
    {
        return $this->allow($nameOrId);
    }
    /**
     * @param  $permissions
     * @param bool $needsAll
     *
     * @return bool
     */
    public function hasPermissions($permissions, $needsAll = false)
    {
        return $this->allowMultiple($permissions, $needsAll);
    }

    /**
     * Alias to eloquent many-to-many relation's attach() method.
     *
     * @param mixed $role
     */
    public function attachRole($role)
    {
        if (is_object($role)) {
            $role = $role->getKey();
        }

        if (is_array($role)) {
            $role = $role['id'];
        }

        $this->roles()->attach($role);
    }

    /**
     * Alias to eloquent many-to-many relation's detach() method.
     *
     * @param mixed $role
     */
    public function detachRole($role)
    {
        if (is_object($role)) {
            $role = $role->getKey();
        }

        if (is_array($role)) {
            $role = $role['id'];
        }

        $this->roles()->detach($role);
    }

    /**
     * Attach multiple roles to a user.
     *
     * @param mixed $roles
     */
    public function attachRoles($roles)
    {
        foreach ($roles as $role) {
            $this->attachRole($role);
        }
    }

    /**
     * Detach multiple roles from a user.
     *
     * @param mixed $roles
     */
    public function detachRoles($roles)
    {
        foreach ($roles as $role) {
            $this->detachRole($role);
        }
    }

    /**
     * Attach multiple Permissions to a user.
     *
     * @param mixed $permissions
     */
    public function attachPermissions($permissions)
    {
        foreach ($permissions as $permission) {
            $this->attachPermission($permission);
        }
    }

    /**
     * Alias to eloquent many-to-many relation's attach() method.
     *
     * @param mixed $permission
     */
    public function attachPermission($permission)
    {
        if (is_object($permission)) {
            $permission = $permission->getKey();
        }

        if (is_array($permission)) {
            $permission = $permission['id'];
        }

        $this->permissions()->attach($permission);
    }

    /**
     * Detach multiple permissions from current role.
     *
     * @param mixed $permissions
     */
    public function detachPermissions($permissions)
    {
        foreach ($permissions as $permission) {
            $this->detachPermission($permission);
        }
    }

    /**
     * Detach permission form current User.
     *
     * @param object|array $permission
     */
    public function detachPermission($permission)
    {
        if (is_object($permission)) {
            $permission = $permission->getKey();
        }

        if (is_array($permission)) {
            $permission = $permission['id'];
        }

        $this->permissions()->detach($permission);
    }
     /**
     * Attach multiple Categories to a user.
     *
     * @param mixed $categories
     */
    public function attachCategories($categories)
    {
        foreach ($categories as $category) {
            $this->attachCategory($category);
        }
    }

    /**
     * Alias to eloquent many-to-many relation's attach() method.
     *
     * @param mixed $category
     */
    public function attachCategory($category)
    {
        if (is_object($category)) {
            $category = $category->getKey();
        }

        if (is_array($category)) {
            $category = $category['id'];
        }

        $this->categories()->attach($category);
    }

    /**
     * Detach multiple categories from current role.
     *
     * @param mixed $categories
     */
    public function detachCategories($categories)
    {
        foreach ($categories as $category) {
            $this->detachCategory($category);
        }
    }

    /**
     * Detach category form current User.
     *
     * @param object|array $category
     */
    public function detachCategory($category)
    {
        if (is_object($category)) {
            $category = $category->getKey();
        }

        if (is_array($category)) {
            $category = $category['id'];
        }

        $this->categories()->detach($category);
    }


}
