<?php

namespace App\Models\Traits\Methods;

use Carbon\Carbon;
use App\Models\Category;
use App\Notifications\Backend\Auth\Notification;
use App\Notifications\Backend\Auth\RenewDocumentNotification;

trait NotificationMethods
{

    static function dailycheck(){
        //
        $documents = Category::whereNotNull('url')->get();
        $yesterday = Carbon::now()->subDay()->toDateString();
        // dd($yesterday);
        foreach ($documents as $document) {

            if ($document->expire_date == $yesterday) {
                Notification::send(new RenewDocumentNotification($document));
            }
        }
    }
}
