<?php

namespace App\Models\Traits\Relationships;

use App\Models\Auth\User;
use App\Models\Category;

trait CategoryRelationships
{
    /**
     * Category belongs to relationship with user.
     */
    public function owner()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Category belongs to relationship with user.
     */
    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function parent_category()
    {
        return $this->belongsTo(Category::class, 'parent_category_id');
    }
    public function getAllParentIds()
    {
        $parentIds = [];

        $category = $this;
        while ($category->parent_category) {
            $parentIds[] = $category->parent_category->id;
            $category = $category->parent_category;
        }

        return $parentIds;
    }

    public function childern_categories()
    {
        return $this->hasMany(Category::class, 'parent_category_id')->whereNull('url');
    }
    public function getAllChildIds()
{
    $childIds = [];

    $categories = $this->childern_categories;
    foreach ($categories as $category) {
        $childIds[] = $category->id;
        $childIds = array_merge($childIds, $category->getAllChildIds());
    }

    return $childIds;
}
public function getAllChilds()
{
    $childs = [];

    $categories = $this->childern_categories;
    foreach ($categories as $category) {
        $childs[] = $category;
        $childs = array_merge($childs, $category->getAllChilds());
    }

    return $childs;
}
    public function users()
    {
        return $this->belongsToMany(User::class,'doc_category_user');
    }
}
