<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserMeta extends Model
{

    protected $table = 'user_metas';
    const DARK_MODE = 'dark_mode';
    const THEME_FONT = 'theme_font';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'name',
        'value',
    ];


    public static function Preferences(\App\Models\Auth\User $user, $name)
    {
        $meta = self::where('user_id', $user->id)->where('name', $name)->first();
        if ($meta != null) {
            $meta = \json_decode($meta->value, true);
        }
        return $meta;
    }
}
