<?php

namespace App\Notifications\Backend\Auth;


use App\Models\Auth\User;
use Illuminate\Bus\Queueable;
use App\Enums\NotificationType;
use App\Models\Category;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class RenewDocumentNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    public function getUsersId()
    {
        return User::where(function($query){
                $query->Where('id',$this->model->created_by);
            })
            ->get()->pluck('id')->toArray();
    }


    public function getNotificationType(): int
    {
        return NotificationType::RENEW_DOCUMENT;
    }


    public function getTranslatedBody($user): string
    {

        $name = 'Documents System';

        return $name . " " . 'Renew This Document' ;

    }

    public function getBody($lang): string
    {
        $name = 'Documents System';

        return $name . " " . 'Go to details';

    }


    public function getCustomData(): string
    {
        $name = 'Renew This Document';

        return $name;
    }

    function getDescription()
    {
        return $this->model->name;
    }

    public function url($id): string
    {
        return route('admin.documents.edit',$this->model->id);

    }

    public function image(): string
    {
        return '';
    }

    public function getDataId($id)
    {
        return $id;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->line('The introduction to the notification.')
            ->action('Notification Action', url('/'))
            ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
