<?php

namespace App\Repositories\Backend;

use App\Exceptions\GeneralException;
use App\Models\Log;
use App\Repositories\BaseRepository;

class LogsRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = Log::class;

    /**
     * Sortable.
     *
     * @var array
     */
    private $sortable = [
        'id',
        'file_anme',
        'url',
        'category_id',
        'created_at',
        'updated_at',
    ];

    /**
     * Retrieve List.
     *
     * @var array
     * @return Collection
     */
    public function retrieveList(array $options = [])
    {
        $perPage = isset($options['per_page']) ? (int) $options['per_page'] : 20;
        $orderBy = isset($options['order_by']) && in_array($options['order_by'], $this->sortable) ? $options['order_by'] : 'created_at';
        $order = isset($options['order']) && in_array($options['order'], ['asc', 'desc']) ? $options['order'] : 'desc';
        $query = $this->query()
            ->orderBy($orderBy, $order);

        if ($perPage == -1) {
            return $query->get();
        }

        return $query->paginate($perPage);
    }

    /**
     * @return mixed
     */
    public function getForDataTable()
    {
        return $this->query()
        ->leftjoin('users', 'users.id', '=', 'doc_logs.user_id')
        ->select([
            'doc_logs.id',
            'doc_logs.model',
            'doc_logs.action',
            'doc_logs.record_id',
            'doc_logs.label',
            'doc_logs.description',
            'doc_logs.created_at',
            'users.name AS user_name',
        ]);
    }





}
