<?php

namespace Database\Seeders;

use App\Models\Auth\Permission;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

use Illuminate\Database\Seeder;

/**
 * Class AddDocsPermissionsSeeder
 * 
 * Seeds all permissions related to the Documents System.
 */
class AddDocsPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        //    $this->disableForeignKeys();
        //      $this->truncateMultiple(['permissions', 'permission_role']);

        // Backend Access Permissions
        $this->createPermission('View Backend', 'view_backend', 'Backend');
        $this->createPermission('View Document Report', 'view_document_report', 'Documents');
        $this->createPermission('View Log Filter', 'view_log_filter', 'Logs');
        $this->createPermission('View Log', 'view_log', 'Logs');

        // Permission Management
        $this->createPermission('Show Permission', 'show_permission', 'Permissions');
        $this->createPermission('View Permission', 'view_permission', 'Permissions');
        $this->createPermission('View Permission Management', 'view_permission_management', 'Permissions');
        $this->createPermission('View Document Permission Management', 'view_permission_document_management', 'Permissions');
        $this->createPermission('Add Document Permission', 'add_permission_document', 'Permissions');
        $this->createPermission('Add Permission', 'add_permission', 'Permissions');
        $this->createPermission('Create Permission', 'create_permission', 'Permissions');
        $this->createPermission('Delete Permission', 'delete_permission', 'Permissions');
        $this->createPermission('Edit Permission', 'edit_permission', 'Permissions');

        // User Management
        $this->createPermission('View Access Management', 'view_access_management', 'Users');
        $this->createPermission('View User Management', 'view_user_management', 'Users');
        $this->createPermission('Activate User', 'activate_user', 'Users');
        $this->createPermission('Deactivate User', 'deactivate_user', 'Users');
        $this->createPermission('Login As User', 'login_as_user', 'Users');
        $this->createPermission('Clear User Session', 'clear_user_session', 'Users');

        // Role Management
        $this->createPermission('View Role Management', 'view_role_management', 'Roles');
        $this->createPermission('View Role', 'view_role', 'Roles');
        $this->createPermission('Create Role', 'create_role', 'Roles');
        $this->createPermission('Edit Role', 'edit_role', 'Roles');
        $this->createPermission('Delete Role', 'delete_role', 'Roles');

        // Categories
        $this->createPermission('View Category', 'view_category', 'Categories');
        $this->createPermission('Create Category', 'create_category', 'Categories');
        $this->createPermission('Edit Category', 'edit_category', 'Categories');
        $this->createPermission('Delete Category', 'delete_category', 'Categories');

        // Settings
        $this->createPermission('Edit Settings', 'edit_settings', 'Settings');

        // Documents
        $this->createPermission('View Document Management', 'view_document', 'Documents');
        $this->createPermission('Create Document', 'create_document', 'Documents');
        $this->createPermission('Edit Document', 'edit_document', 'Documents');
        $this->createPermission('Delete Document', 'delete_document', 'Documents');
        $ids = Permission::where("first_parent", 'Documents System')->pluck("id");
        foreach ($ids as $id) {
            $data[] = array(
                "permission_id" => $id,
                "role_id" => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            );
        }
        DB::table('permission_role')->insert($data);

        //        $this->enableForeignKeys();
    }

    /**
     * Helper method to create permissions.
     */
    private function createPermission($name, $slug, $secondParent)
    {
        Permission::create([
            'name' => $name,
            'slug' => $slug,
            'first_parent' => 'Documents System',
            'second_parent' => $secondParent,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
    }
}
