<?php

namespace Database\Seeders;


use App\Models\Category;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Storage;

/**
 * Class CategorySizeSeeder.
 */
class CategorySizeSeeder extends Seeder
{

    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Retrieve categories with url != null
        $categories = Category::whereNotNull('url')->get();
        foreach ($categories as $category) {
            $filePath = 'uploads/' . $category->url;

            if (Storage::exists($filePath)) {
                $size = Storage::size($filePath);
                $category->size = $size;
                $category->size_s3 = $size;
                $category->save();
                Category:: updateParentCategoriesSizes($category->parent_category_id,$size,true);
            }
        }
    }
}
