(function () {
    let document_id_for_version;
    FTX.Categories = {
        list: {
            selectors: {
                dataContainer: $('.data-container')
            },
            init: function () {
                var self = this;
                $.ajax({
                    url: this.selectors.dataContainer.data('ajax_url'),
                    type: 'post',
                    data: {
                        status: 1,
                        trashed: false,
                        category_id: this.selectors.dataContainer.attr('data-category-id')
                    },
                    beforeSend: function () {
                        $('#tableSkeleton').show();
                        $('.data-list li.data-content').remove();
                    },
                    success: function (response) {
                        $('#tableSkeleton').hide();
                        $('.msg-data').remove();

                        $('hr.table').remove();
                        $('.data-list').append(response);
                        $('.data-list li.header').show();

                        if ($('.btn.grid').hasClass('active')) {
                            $('.btn.grid').trigger('click');
                            $('.file_icon').show();
                        } else {
                            $('.btn.list').trigger('click');
                            $('.file_icon').hide();
                        }

                    },
                    error: function (xhr, status, error) {
                        console.log(error);
                    }
                });
            }
        },
        edit: {
            selectors: {
                categories: jQuery(".categories1"),
                categories_array: $('#categoryarray'),
                parentcategory: $('#parentcategory'),
                users: jQuery(".users"),
                docusers: jQuery(".docusers"),
                permissions: jQuery("#permissionModal .permissions"),
                sharepermissions: jQuery("#shareModal .sharepermissions"),
                docpermissions: jQuery("#permissiondocumentModal .docpermissions"),
                treeDemo: jQuery("#treeDemo"),
                copyButton: jQuery("#copyButton"),
                spanElement: jQuery('.option')
            },

            init: function (locale) {
                this.addHandlers(locale);
                FTX.tinyMCE.init(locale);
            },

            addHandlers: function (locale) {
                var self = this;
                view = $('meta[name=\'view\']').attr('content');
                edit = $('meta[name=\'edit\']').attr('content');
                delete_ = $('meta[name=\'delete\']').attr('content');
                share = $('meta[name=\'share\']').attr('content');
                create = $('meta[name=\'create\']').attr('content');
                var FULL_PERMISSION = (create | edit | delete_ | share);
                var create_edit_share = (create | edit | share);
                var create_delete_share = (create | delete_ | share);
                var create_delete_edit = (create | delete_ | edit);
                var edit_delete_share = (edit | delete_ | share);
                var edit_share = (edit | share);
                var create_edit = (create | edit);
                var create_delete = (create | delete_);
                var delete_share = (delete_ | share);
                var edit_delete = (edit | delete_);
                var create_share = (create | share);

                ['users', 'docusers'].forEach(function (selector) {
                    self.selectors[selector].select2({
                        width: '100%',
                        placeholder: 'Select User',
                        allowClear: true
                    });
                });

                ['permissions', 'docpermissions'].forEach(function (selector) {
                    self.selectors[selector].select2({
                        width: '100%',
                        allowClear: true,
                        multiple: true
                    });
                });
                this.selectors.sharepermissions.select2({
                    width: '100%',
                    allowClear: true,
                    multiple: true
                });
                ///////// category tree //////////
                if ($(this.selectors.treeDemo).length > 0) {
                    this.selectors.treeDemo.jstree({
                        'core': {
                            'data': function (node, callback) {
                                if (node.state.loaded) {  // إذا كانت العقدة محملة مسبقًا، لا تقم بإعادة تحميلها
                                    callback(node.children);
                                    return;
                                }

                                $('#logDetails').hide(); // Instantly hide details
                                $('#logSkeleton').fadeIn(100);
                                //$('.data-content').hide(); // Instantly hide details

                                //   setTimeout(function () {  // تأخير جلب البيانات قليلاً

                                $.ajax({
                                    'url': $('meta[name="root-url"]').attr('content'),
                                    'data': { 'id': node.id },
                                    'dataType': 'json',
                                    'success': function (data) {
                                        data.forEach(function (item) {
                                            if (item.status === 1) {
                                                item.text += " <i class='fas fa-link text-primary'></i>";
                                            }
                                        });

                                        if (data.length > 10) {
                                            let visibleNodes = data.slice(0, 10);

                                            // Add "Show More" button
                                            visibleNodes.push({
                                                "id": node.id + "_separator",  // Unique ID for each parent
                                                "parent": node.id,
                                                "text": "<span class='show-more' data-node='" + node.id + "'><b>⋯</b></span>",
                                                "icon": false,
                                                "state": { "disabled": true }
                                            });
                                            callback(visibleNodes);
                                        } else {
                                            callback(data);
                                            console.log(node.state, node.children)

                                        }
                                        $('#logSkeleton').hide(); // Instantly hide skeleton
                                        $('#logDetails').fadeIn(100);
                                        $('#tableSkeleton').hide();

                                    },
                                    'error': function (xhr, status, error) {
                                        console.error("Error fetching data:", error);
                                        $('#logSkeleton').hide(); // Instantly hide skeleton
                                        $('#logDetails').fadeIn(100);
                                        $('#tableSkeleton').hide();

                                    }
                                });
                                // },50)
                            }
                        },
                        "themes": {
                            dots: false,
                            "icons": false,
                            "variant": "large",
                            "responsive": true
                        },
                        "types": {
                            "default": {
                                "icon": "ki-outline ki-older"
                            },

                        },
                        "search": {
                            "case_sensitive": false,
                            "show_only_matches": true
                        },
                        "plugins": ["changed", "themes", "types", "search"]
                    }).on('search.jstree', function (nodes, str, res) {
                        if (str.nodes.length === 0) {
                            $('#treeDemo').jstree(true).hide_all();
                        }
                    });
                    $(document).on('contextmenu', 'a[id$="_separator_anchor"]', function (e) {
                        //hideMenu();
                    });
                    $('#search-input').keyup(function () {
                        $('#treeDemo').jstree(true).show_all();
                        $('#treeDemo').jstree('search', $(this).val());
                    });
                    function handleCategorySelection(categoryid, permissions) {
                        $('.close-select').trigger('click');
                        $('.data-container').attr('data-category-id', categoryid);
                        $('#categoryid').val(categoryid);
                        if ($('.btn.grid').hasClass('active')) {
                            $('.btn.grid').trigger('click');
                            $('.file_icon').show();
                        } else {
                            $('.btn.list').trigger('click');
                            $('.file_icon').hide();
                        }
                        FTX.Categories.list.init();
                        // $.ajax({
                        //     url: FTX.Categories.edit.selectors.getcategorypathURL,
                        //     method: 'GET',
                        //     data: { categoryid: categoryid },
                        //     success: function (response) {
                        //     $('.categorypath').text(response);
                        //     },
                        //     error: function (xhr, status, error) {
                        //     }
                        // });
                        logs(categoryid);
                    }

                    function logs(categoryid) {
                        $.ajax({
                            url: FTX.Categories.edit.selectors.getlogURL,
                            method: 'GET',
                            data: { categoryid: categoryid },
                            success: function (response) {
                                $('.content').show();
                                $("#activity").empty();
                                $(".type-value,.size-value,.sizes3-value,.location-value,.owner-value,.modified-value,.created-value").empty();
                                $('.cat-section').attr('href', response.details.url);
                                var currentFancybox = $('.cat-section').data('fancybox');
                                $('.cat-section').data('fancybox', currentFancybox + response.details.id);
                                $('.cat-section .attachment-thumbnail').attr('src', response.details.attachment);
                                $('.cat-section .categoryname').text(response.details.name);
                                $('.header-name').empty();
                                $('.header-name').addClass('jstree-anchor');
                                $('.header-name').append('<i class="jstree-icon jstree-themeicon ki-outline ki-older jstree-themeicon-custom" role="presentation"></i>' + '<div class="header-name-text">' + response.details.name + '</div>');
                                $('.type-value').text(response.details.type);
                                $('.size-value').text(response.details.size);
                                $('.sizes3-value').text(response.details.size_server);
                                $('.location-value').text(response.details.location);
                                $('.owner-value').text(response.details.owner);
                                $('.modified-value').text(response.details.updatedat + response.details.updater);
                                $('.created-value').text(response.details.createdat);
                                $.each(response.activities, function (index, activity) {

                                    var rowDiv = $('<div class="container mt-3"></div>');
                                    var firstRowContent = $('<div class="row align-items-center">');
                                    firstRowContent.append($('<div class="col-md-2 text-center">').append($('<img src="' + response.details.user_picture + '" class="img-1">')));
                                    firstRowContent.append($('<div class="col ml-2">').append($('<div class="d-flex justify-content-between">').html(activity.text))
                                        .append($('<div class="d-flex justify-content-between align-items-center">').html(activity.date)));
                                    rowDiv.append(firstRowContent);

                                    var secondRowContent = $('<div class="row">');
                                    secondRowContent.append($('<div class="col-md-2"></div>'));
                                    secondRowContent.append($('<div class="col ml-2">').append($('<div class="d-flex align-items-center mt-2">').append(
                                        $('<a data-fancybox="gallery' + response.details.id + '" href="' + response.details.url + '" class="d-flex border-item">').append(
                                            $('<img class="attachment-thumbnail" style="width: 43px; height: auto; padding: 2px; object-fit: contain; margin-right: 3px;" src="' + response.details.attachment + '">')
                                        ).append($('<div class="categoryname ">').html(response.details.name)))));
                                    rowDiv.append(secondRowContent);


                                    $("#activity").append(rowDiv);
                                });
                            },
                            error: function (xhr, status, error) {
                                // Handle error
                            }
                        });
                    }
                    function showMenu(x, y, nodeId, permissions, isDoc) {
                        var menuContainer = document.querySelector('.menu-container');
                        $('.menu-container').data('category', nodeId);
                        menuContainer.style.left = x + 'px';
                        menuContainer.style.top = y + 'px';
                        menuContainer.style.display = 'block';
                        updateContextMenu(nodeId, permissions, isDoc);
                    }
                    function updateContextMenu(nodeId, permissions, isDoc) {
                        if (isDoc == "no") {
                            $('.category_user,.add_category_user').show();
                            $('.document_user,.add_document_user,.versions').hide();
                        } else {
                            $('.btn.versions').attr('data-document', nodeId);
                            $('.document_user,.add_document_user,.versions').show();
                            $('.category_user,.add_category_user').hide();

                        }
                        console.log("permissions" + permissions);
                        $('.create_document, .create_category,.edit_category,.edit_document,.delete_category,.delete_document,.item-menu .share').hide();
                        if (isDoc == "no" && (permissions == create || permissions == create_edit || permissions == create_delete || permissions == create_share || permissions == create_edit_share || permissions == create_delete_share || permissions == create_delete_edit || permissions == FULL_PERMISSION)) {
                            $('.create_document, .create_category').show();
                        }
                        if (permissions == edit || permissions == create_edit || permissions == edit_delete || permissions == edit_share || permissions == create_edit_share || permissions == edit_delete_share || permissions == create_delete_edit || permissions == FULL_PERMISSION) {
                            if (isDoc == "no") $('.edit_category').show();
                            else $('.edit_document').show();
                        }
                        if (permissions == delete_ || permissions == create_delete || permissions == edit_delete || permissions == delete_share || permissions == edit_delete_share || permissions == create_delete_share || permissions == create_delete_edit || permissions == FULL_PERMISSION) {
                            if (isDoc == "no") $('.delete_category').show();
                            else $('.delete_document').show();
                        }
                        if (permissions == share || permissions == create_share || permissions == edit_share || permissions == delete_share || permissions == edit_delete_share || permissions == create_delete_share || permissions == create_edit_share || permissions == FULL_PERMISSION) {

                            $('.item-menu .share').show();
                        }
                        //////////Log///////
                        console.log("nodeId" + nodeId);
                        $(".log_info button").attr('data-id', nodeId);
                        $('.item-menu.share').removeAttr('disabled');
                        $(".share button").attr("data-category", nodeId);
                        $('.btn.add_document_user').attr('data-document', nodeId);
                        $('.btn.add_category_user').attr('data-category', nodeId);
                        $('#documentid').val(nodeId);
                        $('#categoryid').val(nodeId);
                        ////////////////Create Document///////////
                        var routeURL = FTX.Categories.edit.selectors.createdocumentURL;
                        $('.create_document').attr('href', routeURL + nodeId);
                        if ($('.create_document').hasClass('disabled-link')) {
                            $('.create_document').removeClass('disabled-link');
                        };
                        ////////////////Create Category///////////
                        var creatroute = FTX.Categories.edit.selectors.createcategoryURL;
                        $('.create_category').attr('href', creatroute + nodeId);
                        if ($('.create_category').hasClass('disabled-link')) {
                            $('.create_category').removeClass('disabled-link');
                        }
                        ////////////////User Category///////////
                        var categoryUserURL = FTX.Categories.edit.selectors.categoryUserURL;
                        $('.category_user').attr('href', categoryUserURL + nodeId);
                        var documentUserURL = FTX.Categories.edit.selectors.documentUserURL;
                        $('.document_user').attr('href', documentUserURL + nodeId);

                        ////////////////Edit Category///////////
                        var editrouteURL = FTX.Categories.edit.selectors.editcategoryURL;
                        $('.edit_category').removeClass('disabled-link');
                        $('.edit_category').attr('href', editrouteURL.replace('category', nodeId));
                        var editdocrouteURL = FTX.Categories.edit.selectors.editdocURL;
                        $('.edit_document').removeClass('disabled-link');
                        $('.edit_document').attr('href', editdocrouteURL.replace('category', nodeId));

                        var downloadrouteURL = FTX.Categories.edit.selectors.downloadcategoryURL;
                        $('.download').attr('href', downloadrouteURL + nodeId);

                        ////////////Delete Category///////////////
                        var destroyrouteURL = FTX.Categories.edit.selectors.deletecategoryURL;
                        var destroyroute = destroyrouteURL.replace('categoryId', nodeId) + '?_method=DELETE';
                        $('.delete_category').removeAttr('disabled');
                        $('.delete_category').data('method', 'delete');
                        $('.delete_category').on('click', function (event) {
                            event.preventDefault();
                            var link = $(this);
                            var title = link.attr('data-trans-title') || 'Are you sure you want to delete this item?';
                            var confirmText = link.attr('data-trans-button-confirm') || 'Yes, delete';

                            Swal.fire({
                                title: title,
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonText: confirmText,
                                cancelButtonText: 'Cancel'
                            }).then(function (result) {
                                if (result.value) {
                                    var form = $('<form>', {
                                        method: 'POST',
                                        action: destroyroute
                                    }).append(
                                        $('<input>', {
                                            type: 'hidden',
                                            name: '_method',
                                            value: 'DELETE'
                                        }),
                                        $('<input>', {
                                            type: 'hidden',
                                            name: '_token',
                                            value: $('meta[name="csrf-token"]').attr('content')
                                        })
                                    );

                                    form.appendTo('body').submit();
                                }
                            });
                        });
                        var destroydocrouteURL = FTX.Categories.edit.selectors.deletedocURL;
                        var destroydocroute = destroydocrouteURL.replace('categoryId', nodeId) + '?_method=DELETE';
                        $('.delete_document').removeAttr('disabled');
                        $('.delete_document').data('method', 'delete');
                        $('.delete_document').on('click', function (event) {
                            event.preventDefault();
                            var link = $(this);
                            var title = link.attr('data-trans-title') || 'Are you sure you want to delete this item?';
                            var confirmText = link.attr('data-trans-button-confirm') || 'Yes, delete';

                            Swal.fire({
                                title: title,
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonText: confirmText,
                                cancelButtonText: 'Cancel'
                            }).then(function (result) {
                                if (result.value) {
                                    var form = $('<form>', {
                                        method: 'POST',
                                        action: destroydocroute
                                    }).append(
                                        $('<input>', {
                                            type: 'hidden',
                                            name: '_method',
                                            value: 'DELETE'
                                        }),
                                        $('<input>', {
                                            type: 'hidden',
                                            name: '_token',
                                            value: $('meta[name="csrf-token"]').attr('content')
                                        })
                                    );

                                    form.appendTo('body').submit();
                                }
                            });
                        });
                    }
                    function hideMenu() {
                        var menuContainer = document.querySelector('.menu-container');
                        menuContainer.style.display = 'none';
                        $('.data-content').css('background-color', '');
                    }
                    this.selectors.treeDemo.on('changed.jstree', function (e, data) {
                        var categoryid = data.changed.selected[0];
                        var selectedNode = data.instance.get_node(data.selected[0]);
                        //  data.instance.open_node(selectedNode);
                        var permissions = selectedNode.data && selectedNode.data.permissions;

                        handleCategorySelection(categoryid, permissions);
                    });
                    this.selectors.treeDemo.on('contextmenu', 'a', function (e, data) {
                       // e.preventDefault();
                        var nodeId = $(this).parent().attr('id');
                        var jstreeInstance = $("#treeDemo").jstree();
                        var selectedNode = jstreeInstance.get_node(nodeId);
                        var permissions = selectedNode.data && selectedNode.data.permissions;
                        showMenu(e.pageX, e.pageY, nodeId, permissions, "no");
                    });
                    function handleContextMenuAndClick(e) {
                        e.preventDefault();
                        var permissions = '';
                        var isDoc = '';
                        var nodeId = $(this).closest('.data-content').attr('data-id');

                        $('.data-content').css('background-color', '');
                        $(this).closest('.data-content').css('background-color', '#d5f4fe');
                        var selectedNode = $("#treeDemo").jstree(true).get_node(nodeId);
                        permissions = $(this).closest('.data-content').attr('data-permission');
                        if ($.trim(permissions) !== '') {
                            isDoc = "yes";
                        } else {
                            isDoc = "no";
                            permissions = selectedNode.data && selectedNode.data.permissions;
                        }
                        document_id_for_version = nodeId;
                        showMenu(e.pageX - 150, e.pageY, nodeId, permissions, isDoc);
                    }

                    $(document).on('contextmenu', '.data-content span.option', handleContextMenuAndClick);
                    $(document).on('contextmenu', '.data-content', handleContextMenuAndClick);

                    $(document).on('click', '.data-content span.option', handleContextMenuAndClick);

                    document.addEventListener('click', function (event) {
                        if (!$(event.target).closest('.data-content span.option').length) {
                            //  hideMenu();
                        }
                    });

                    $(document).on('click', '.Folder', function (e) {
                        var categoryid = $(this).data('category');
                        console.log("categoryid" + categoryid);
                        var jstreeInstance = $("#treeDemo").jstree();
                        var selectedNode = jstreeInstance.get_node(categoryid);
                        var permissions = selectedNode.data && selectedNode.data.permissions;
                        handleCategorySelection(categoryid, permissions);
                        jstreeInstance.deselect_all();
                        if (!selectedNode.state.opened) {
                            jstreeInstance.open_node(selectedNode, function () {
                                jstreeInstance.select_node(selectedNode);
                            });
                        } else {
                            jstreeInstance.select_node(selectedNode);
                        }
                    });
                }
                var categoriesSelect = this.selectors.categories;
                var parentcategory = this.selectors.parentcategory;
                if (parentcategory) {
                    categoriesSelect.val($('#parentcategory').val()).trigger('change');
                }

                $('#permissiondocumentModal .close, #permissiondocumentModal .cancel, .close, .cancel').on('click', function (e) {
                    $('.docpermissions, .permissions').val('').trigger('change');
                    $('.docusers, .users').val('').trigger('change');
                    $('#permissiondocumentModal #responseMessage, #responseMessage').text('');
                });
                $('#submitFormBtn').on('click', function (e) {
                    e.preventDefault();

                    if (!$('.users').val() && $(this).data('edit') != 'yes') {
                        alert($(this).data('user'));
                        return;
                    }
                    if ($('.permissions').val().length === 0) {
                        alert($(this).data('permission'));
                        return;
                    }
                    var url = FTX.Categories.edit.selectors.giveuserCategoryURL;
                    var userid = $('.users').val();
                    if ($(this).data('edit') == 'yes') {
                        url = FTX.Categories.edit.selectors.edituserCategoryURL;
                        userid = $('#userspan').data('value');
                    }
                    var formData = {
                        userId: userid,
                        categoryid: $('#categoryid').val(),
                        permissions: $('.permissions').val(),
                    };

                    $.ajax({
                        type: 'POST',
                        url: url,
                        data: formData,
                        dataType: 'json',
                        success: function (response) {
                            $('#responseMessage').html('<div class="alert alert-success">' + response.message + '</div>');
                            setTimeout(function () {
                                $('.close').trigger('click');
                            }, 1500);
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            $('#responseMessage').html('<div class="alert alert-danger">An error occurred.</div>');
                        }
                    });
                });

                $('.savepermissiondocument').on('click', function (e) {

                    e.preventDefault(); // Prevent form submission
                    var document_id = $('#documentid').val();
                    var category_id = $('.add_document_user').data('category');
                    if (!$('#docusers').val() && $(this).data('edit') != 'yes') {
                        alert($(this).data('user'));
                        return;
                    }
                    if ($('#docpermissions').val().length === 0) {
                        alert($(this).data('permission'));
                        return;
                    }
                    var url = FTX.Categories.edit.selectors.giveuserDocumentURL;
                    var userid = $('.docusers').val();
                    if ($(this).data('edit') == 'yes') {
                        url = FTX.Categories.edit.selectors.edituserDocumentURL;
                        userid = $('#userspan1').data('value');

                    }
                    var formData = {
                        userId: userid,
                        categoryid: category_id,
                        documentid: document_id,
                        permissions: $('#docpermissions').val(),
                    };
                    $.ajax({
                        type: 'POST',
                        url: url,
                        data: formData,
                        dataType: 'json',
                        success: function (response) {
                            $('#permissiondocumentModal #responseMessage').html('<div class="alert alert-success">' + response.message + '</div>');
                            setTimeout(function () {
                                $('#permissiondocumentModal .close').trigger('click');
                            }, 1500);
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            $('#permissiondocumentModal #responseMessage').html('<div class="alert alert-danger">An error occurred.</div>');
                        }
                    });
                });

                function handlePermissionChange(userId, categoryid) {
                    var getuserCategoryURL = FTX.Categories.edit.selectors.getuserCategoryURL;
                    var callback = {
                        success: function (response) {
                            if (response !== -1) {
                                var permissions = [view];
                                if (response == create || response == create_edit || response == create_delete || response == create_share || response == create_edit_share || response == create_delete_share || response == create_delete_edit || response == FULL_PERMISSION) {
                                    permissions.push(create);
                                }
                                if (response == edit || response == create_edit || response == edit_delete || response == edit_share || response == create_edit_share || response == edit_delete_share || response == create_delete_edit || response == FULL_PERMISSION) {
                                    permissions.push(edit);
                                }
                                if (response == delete_ || response == create_delete || response == edit_delete || response == delete_share || response == edit_delete_share || response == create_delete_share || response == create_delete_edit || response == FULL_PERMISSION) {
                                    permissions.push(delete_);
                                }
                                if (response == share || response == create_share || response == edit_share || response == delete_share || response == create_edit_share || response == edit_delete_share || response == create_delete_share || response == FULL_PERMISSION) {
                                    permissions.push(share);
                                }
                                if ($('#submitFormBtn').data('edit') == 'yes') {
                                    $('#permissions').val(permissions).trigger('change');
                                } else {
                                    $('#message').text('you already have permission');
                                    $('#submitFormBtn').prop('disabled', true);
                                    $('#permissions').prop('disabled', true);
                                }
                            }


                        },
                        error: function () {
                            // Error handling
                        }
                    };

                    if (userId != null) {

                        $.ajax({
                            url: getuserCategoryURL,
                            type: 'POST',
                            data: {
                                categoryid: categoryid,
                                userId: userId
                            },
                            dataType: 'json',
                            success: callback.success,
                            error: callback.error
                        });
                    }
                }

                $('.editpermissioncategory').on('click', function (e) {
                    var userId = $(this).data('user');
                    var categoryid = $(this).data('category');
                    var username = $(this).data('username');
                    $('#categoryid').val(categoryid);
                    $('#userspan').text(username);
                    $('#userspan').attr('data-value', userId);
                    handlePermissionChange(userId, categoryid);
                });

                $('.users').on('change', function () {
                    $('#permissions').prop('disabled', false);
                    $('#submitFormBtn').prop('disabled', false);
                    $('#message').text('');
                    var userId = $(this).val();
                    var categoryid = $('#categoryid').val();
                    handlePermissionChange(userId, categoryid);
                });
                function handlePermissionChange2(userId, documentid) {
                    var getuserDocumentURL = FTX.Categories.edit.selectors.getuserDocumentURL;
                    var callback = {
                        success: function (response) {
                            if (response !== -1) {
                                var permissions = [view];
                                if (response == edit || response == edit_delete || response == edit_share || response == edit_delete_share) {
                                    permissions.push(edit);
                                }
                                if (response == delete_ || response == edit_delete || response == delete_share || response == edit_delete_share) {
                                    permissions.push(delete_);
                                }
                                if (response == share || response == edit_share || response == delete_share || response == edit_delete_share) {
                                    permissions.push(share);
                                }
                                if ($('.savepermissiondocument').data('edit') == 'yes') {
                                    $('#docpermissions').val(permissions).trigger('change');
                                } else {
                                    $('#permissiondocumentModal #message').text('you already have permission');
                                    $('.savepermissiondocument').prop('disabled', true);
                                    $('.docpermissions').prop('disabled', true);
                                }
                            }


                        },
                        error: function () {
                            // Error handling
                        }
                    };

                    if (userId != null) {

                        $.ajax({
                            url: getuserDocumentURL,
                            type: 'POST',
                            data: {
                                documentid: documentid,
                                userId: userId
                            },
                            dataType: 'json',
                            success: callback.success,
                            error: callback.error
                        });
                    }
                }

                $('.editpermissiondocument').on('click', function (e) {
                    var userId = $(this).data('user');
                    var documentid = $(this).data('document');
                    var username = $(this).data('username');
                    $('#documentid').val(documentid);
                    $('#userspan1').text(username);
                    $('#userspan1').attr('data-value', userId);
                    handlePermissionChange2(userId, documentid);
                });

                this.selectors.docusers.on('change', function () {
                    $('#docpermissions').prop('disabled', false);
                    $('.savepermissiondocument').prop('disabled', false);
                    $('#permissiondocumentModal #message').text('');
                    var userId = $(this).val();
                    var documentid = $('#documentid').val();
                    handlePermissionChange2(userId, documentid);
                });
                $(document).on('click', '.log_info button', function (e) {

                    e.preventDefault();
                    var categoryid = $(this).closest('.log_info button').attr('data-id');
                    $('.info-circle').toggleClass('highlight');
                    $('.log-section').show();
                    $('.tree-col').removeClass('col-lg-3');
                    $('.table-col').removeClass('col-lg-9');
                    $('.tree-col').addClass('col-lg-2');
                    $('.table-col').addClass('col-lg-7');
                    logs(categoryid);
                });
                $(".share button").on('click', function (e) {

                    var categoryid = $(this).data('category');
                    $('#shareModal #categoryid').val(categoryid);
                    $('#shareModal #sharepermissions').val('').trigger('change');
                    $('#shareModal #urlInput').val('');
                    $('#shareModal #expiration').val('');
                    $('#shareModal .copyurl').hide();
                    var getuserCategoryURL = FTX.Categories.edit.selectors.getuserCategoryURL;
                    var callback = {
                        success: function (response) {
                            if (response !== -1) {
                                $('#sharepermissions').find('option[value="' + view + '"]').prop('disabled', false);
                                if (response == create || response == create_edit || response == create_delete || response == create_share || response == create_edit_share || response == create_delete_share || response == create_delete_edit || response == FULL_PERMISSION) {
                                    $('#sharepermissions').find('option[value="' + create + '"]').prop('disabled', false);

                                }
                                if (response == edit || response == create_edit || response == edit_delete || response == edit_share || response == create_edit_share || response == edit_delete_share || response == create_delete_edit || response == FULL_PERMISSION) {
                                    $('#sharepermissions').find('option[value="' + edit + '"]').prop('disabled', false);
                                }
                                if (response == delete_ || response == create_delete || response == edit_delete || response == delete_share || response == edit_delete_share || response == create_delete_share || response == create_delete_edit || response == FULL_PERMISSION) {
                                    $('#sharepermissions').find('option[value="' + delete_ + '"]').prop('disabled', false);
                                }
                                if (response == share || response == create_share || response == edit_share || response == delete_share || response == create_edit_share || response == edit_delete_share || response == create_delete_share || response == FULL_PERMISSION) {
                                    $('#sharepermissions').find('option[value="' + share + '"]').prop('disabled', false);
                                }

                            }


                        },
                        error: function () {
                            // Error handling
                        }
                    };
                    $.ajax({
                        url: getuserCategoryURL,
                        type: 'POST',
                        data: {
                            categoryid: categoryid,
                            userId: $('#userid').val()
                        },
                        dataType: 'json',
                        success: callback.success,
                        error: callback.error
                    });
                });
                $('#generateButton').on('click', function (e) {
                    e.preventDefault();


                    if ($('#shareModal .sharepermissions').val().length === 0) {
                        alert($(this).data('permission'));
                        return;
                    }
                    if (!$('#shareModal #expiration').val()) {
                        alert($(this).data('expiration'));
                        return;
                    }
                    var url = FTX.Categories.edit.selectors.shareURL;
                    var formData = {
                        expiration: $('#expiration').val(),
                        categoryid: $('#shareModal #categoryid').val(),
                        permissions: $('#shareModal .sharepermissions').val(),
                    };

                    $.ajax({
                        type: 'GET',
                        url: url,
                        data: formData,
                        dataType: 'json',
                        success: function (response) {
                            $('#urlInput').val(response.signedUrl);
                            $('.copyurl').show();
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            // Handle error, if any
                            $('#responseMessage').html('<div class="alert alert-danger">An error occurred.</div>');
                        }
                    });
                });
                this.selectors.copyButton.on("click", function () {
                    var urlInput = $("#urlInput")[0];
                    urlInput.select();
                    urlInput.setSelectionRange(0, 99999); /* For mobile devices */
                    try {
                        navigator.clipboard.writeText(urlInput.value);
                        alert("URL copied to clipboard!");
                    } catch (err) {
                        console.error("Failed to copy URL to clipboard:", err);
                    }
                });
                $('.close-btn').on("click", function () {
                    $('.log-section').hide();
                    $('.info-circle').removeClass('highlight');
                    $('.tree-col').removeClass('col-lg-2');
                    $('.table-col').removeClass('col-lg-7');
                    $('.tree-col').addClass('col-lg-3');
                    $('.table-col').addClass('col-lg-9');
                });
                $('.close-select').on("click", function () {
                    $('.options-list ').hide();
                });

                $('.info-circle').on("click", function () {
                    if ($(this).hasClass('highlight')) {
                        $(this).removeClass('highlight');
                        $('.log-section').hide();
                        $('.tree-col').removeClass('col-lg-2');
                        $('.table-col').removeClass('col-lg-7');
                        $('.tree-col').addClass('col-lg-3');
                        $('.table-col').addClass('col-lg-9');

                    } else {
                        $(this).toggleClass('highlight');
                        $('.log-section').show();
                        $('.tree-col').removeClass('col-lg-3');
                        $('.table-col').removeClass('col-lg-9');
                        $('.tree-col').addClass('col-lg-2');
                        $('.table-col').addClass('col-lg-7');
                    }
                });

                $('.list').on('click', function () {
                    $(this).addClass('active');
                    $('.grid').removeClass('active');
                    $('.data-list .header').show();
                    $('hr.table').show();
                    $('.file_icon').hide();
                    var folderItems = $('.data-list .data-content');
                    $('.data-list').removeClass('dataContWrap');
                    folderItems.each(function () {
                        $(this).find('.serial_number, .type, .category,.version, .owner,.icon:eq(1)').show();
                        $(this).addClass('list');
                        $(this).removeClass('grid');
                    });
                });

                $('.grid').on('click', function () {
                    $(this).addClass('active');
                    $('.list').removeClass('active');

                    $('.data-list .header').hide();
                    var folderItems = $('.data-list .data-content');
                    $('.data-list').addClass('dataContWrap');
                    $('.file_icon').show();
                    folderItems.each(function () {
                        $(this).find('.serial_number, .type, .category,.version, .owner,.icon:eq(1)').hide();
                        $(this).addClass('grid');
                        $(this).removeClass('list');

                    });
                    $('hr.table').hide();
                    $('.data-list').each(function () {
                        var $wrapper = $(this);
                        if ($wrapper.children('.msg-data').length === 1 && $wrapper.children().length === 1) {
                            $wrapper.removeClass('dataContWrap');
                        }
                    });
                });

                $(document).on('click', '.data-content', function (event) {
                    var clickedItem = $(this);
                    if (!event.ctrlKey) {
                        $('.data-content.selected').removeClass('selected');
                    }
                    clickedItem.toggleClass('selected');
                    updateSelectedCount();

                    // Update the visibility of the send email button
                    updateSendEmailButtonVisibility();
                });

                // Function to update the visibility of the send email button
                function updateSendEmailButtonVisibility() {
                    var documentUrl = $('#documentUrl').val();

                    if (documentUrl.trim() !== "") {
                        // If there is a document, show the button
                        $('#sendEmailButton, #view-file').show();
                    } else {
                        // If there is no document, hide the button
                        $('#sendEmailButton, #view-file').hide();
                    }
                }

                function updateSelectedCount() {
                    var selectedCount = $('.data-content.selected').length;
                    if (selectedCount > 0) {
                        $('.options-list').show();
                    }
                    var selectedIds = $('.data-content.selected').map(function () {
                        return $(this).data('id');
                    }).get();

                    if (selectedCount == 1) {
                        var downloadrouteURL = FTX.Categories.edit.selectors.downloadcategoryURL;
                        // console.log("hiiiiiiiiii",downloadrouteURL + selectedIds[0]);
                        $('#view-file').val(selectedIds[0]);
                        $('.download-multi').attr('href', downloadrouteURL + selectedIds[0]);

                        //$('.send-email').attr('href', downloadrouteURL + selectedIds[0]);
                        $('#document-id').val(selectedIds[0]);

                        //console.log("hiiiiiiiiii",selectedIds[0])

                    } else if (selectedCount > 1) {
                        var downloadMultipleFilesURL = FTX.Categories.edit.selectors.downloadMultipleFilesURL;
                        $('.download-multi').attr('href', downloadMultipleFilesURL.replace('categoryids', selectedIds.join(',')));
                        $('.send-email').attr('href', downloadMultipleFilesURL.replace('categoryids', selectedIds.join(',')));
                        $('#document-id').val(selectedIds.join(','));

                    }



                    var deletefileURL = FTX.Categories.edit.selectors.deletefiles;
                    var deletefileroute = deletefileURL.replace('categoryids', selectedIds.join(','));
                    $('.delete_doc').removeAttr('disabled');
                    $('.delete_doc').data('method', 'delete');
                    $('.delete_doc').on('click', function (event) {
                        event.preventDefault();
                        var link = $(this);
                        var title = link.attr('data-trans-title') || 'Are you sure you want to delete these items?';
                        var confirmText = link.attr('data-trans-button-confirm') || 'Yes, delete';

                        Swal.fire({
                            title: title,
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonText: confirmText,
                            cancelButtonText: 'Cancel'
                        }).then(function (result) {
                            if (result.value) {
                                var form = $('<form>', {
                                    method: 'POST',
                                    action: deletefileroute
                                }).append(
                                    $('<input>', {
                                        type: 'hidden',
                                        name: '_method',
                                        value: 'DELETE'
                                    }),
                                    $('<input>', {
                                        type: 'hidden',
                                        name: '_token',
                                        value: $('meta[name="csrf-token"]').attr('content')
                                    })
                                );

                                form.appendTo('body').submit();
                            }
                        });
                    });
                    $('.num-items').text(selectedCount + ' Selected');
                }

                $(document).on('keydown', function (event) {
                    if (event.key === 'Control') {
                        $('.data-list').addClass('ctrl-pressed');
                    }
                });

                $(document).on('keyup', function (event) {
                    if (event.key === 'Control') {
                        $('.data-list').removeClass('ctrl-pressed');
                    }
                });

                $(document).on('click', function (event) {
                    if (!$(event.target).closest('.data-list').length) {
                        $('.data-content.selected').removeClass('selected');
                    }
                });
                $('.data-list').on('contextmenu', function (event) {
                    event.preventDefault();

                });

                $('.versions').on('click', function () {
                    var document_id = document_id_for_version;
                    var getHistoryUrl = FTX.Categories.edit.selectors.getHistoryUrl;
                    $.ajax({
                        url: getHistoryUrl,
                        type: 'get',
                        data: {
                            category_id: document_id,
                        },
                        success: function (response) {
                            $('.msg-data').remove();
                            $('.data-list li.data-content').remove();
                            $('hr.table').remove();
                            $('.data-list').append(response);

                            $('.data-list li.header').show();

                            if ($('.btn.grid').hasClass('active')) {
                                $('.btn.grid').trigger('click');
                            } else {
                                $('.btn.list').trigger('click');
                            }
                        },
                        error: function (xhr, status, error) {
                            console.log(error);
                        }
                    });
                });
            },
        },
    }
    $('#treeDemo').on("click", ".jstree-anchor", function (e) {
        let instance = $.jstree.reference(this);
        let node = instance.get_node(this);
        var parent = $(this).closest("li");

        console.log("1", node.state);
       
         
        setTimeout(function () {
            if (node.state.opened) {
                instance.close_node(node);
                console.log("2", node.state);
            } else {
                instance.open_node(node);
                console.log("3", node.state);
            }    

            if (parent.hasClass("jstree-last")) {
                //    console.log("ewewwew");
                parent.find(".jstree-node").each(function () {
                    $(this).addClass("jstree-closed");
                });
            }
        }, 100);
    });

   /* $('#treeDemo').on("click", " .jstree-anchor", function (e) {
          var _this = this;
          var node = $(_this).closest("li");
          if (node.hasClass("jstree-closed")) {
              $('#treeDemo').jstree("open_node", node);
          }else{
              $('#treeDemo').jstree("close_node", node);
              setTimeout(function () {
                  if (node.hasClass("jstree-last")) {
                      node.find(".jstree-node").each(function () {
                          $(this).addClass("jstree-closed");
                      });
                  }
              }, 100);
          }
  
  
      });
   */
    $(document).on("click", ".jstree-last .jstree-closed", function (e) {
        if ($(this).children("ul").length == 0) {
            var $li = $(this); // 
            var $siblings = $li.siblings(); //       
            $siblings.addClass("jstree-closed");
            $li.removeClass("jstree-closed");

        }
    });

})();
