<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Labels Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used in labels throughout the system.
    | Regardless where it is placed, a label can be listed here so it is easily
    | found in a intuitive way.
    |
    */

    'general' => [
        'all' => 'All',
        'yes' => 'Yes',
        'no' => 'No',
        'copyright' => 'Copyright',
        'custom' => 'Custom',
        'actions' => 'Actions',
        'active' => 'Active',
        'Upload_Date_Start'=>'Upload Date Start',
        'Upload_Date_End'=>'Upload Date End',
        'Activity_Log'=>'Activity Log',
        'main_page'=>'Main Page',
        'permission_modal'=>'Permissions',
        'buttons' => [
            'save' => 'Save',
            'update' => 'Update',
        ],
        'hide' => 'Hide',
        'inactive' => 'Inactive',
        'none' => 'None',
        'show' => 'Show',
        'toggle_navigation' => 'Toggle Navigation',
        'create_new' => 'Create New',
        'toolbar_btn_groups' => 'Toolbar with button groups',
        'more' => 'More',
    ],

    'backend' => [
        'access' => [
            'roles' => [
                'create' => 'Create Role',
                'edit' => 'Edit Role',
                'management' => 'Role Management',
                'label' => 'Roles',
                'all' => 'Roles',

                'table' => [
                    'number_of_users' => 'Number of Users',
                    'permissions' => 'Permissions',
                    'role' => 'Role',
                    'sort' => 'Sort',
                    'total' => 'role total|roles total',
                ],
            ],
            'logs' => [
                'management' =>'Logs Management',
                'label' => 'Logs',

                'table' => [
                    'model' => 'Model',
                    'action' => 'Action',
                    'record_id'=>'Record ID',
                    'label'=>'Label',
                    'user' => 'User',
                    'datetime' => 'Date Time',
                    'description' => 'Description',
                ],
            ],
            'permissions' => [
                'all' => 'All Permissions',
                'active' => 'Permission List',
                'create' => 'Create Permission',
                'deactivated' => 'Deactivated Permission',
                'deleted' => 'Deleted Permission',
                'edit' => 'Edit Permission',
                'management' => 'Permission Management',
                'label' => 'Permissions',
                'list' => 'Permission List',

                'table' => [
                    'created' => 'Created',
                    'id' => 'ID',
                    'last_updated' => 'Last Updated',
                    'permission' => 'Permission',
                    'display_name' => 'Display Name',
                    'sort' => 'Sort',
                    'status' => 'Status',
                    'createdby' => 'Created By',
                    'createdat' => 'Created At',
                    'total' => 'permissions total|permissions total',
                ],
            ],
            'usercategory' => [
                'user_category'=>'Category Users',

                'table' => [
                    'created' => 'Created',
                    'id' => 'ID',
                    'last_updated' => 'Last Updated',
                    'category' => 'Category',
                    'user_name' => 'User Name',
                    'createdby' => 'Created By',
                    'createdat' => 'Created At',
                    'total' => 'usercategory total|usercategory total',
                ],
            ],
            'userdocument' => [
                'user_document'=>'Document Users',
            ],
            'users' => [
                'active' => 'Active Users',
                'all_permissions' => 'All Permissions',
                'change_password' => 'Change Password',
                'change_password_for' => 'Change Password for :user',
                'create' => 'Create User',
                'deactivated' => 'Deactivated Users',
                'deleted' => 'Deleted Users',
                'edit' => 'Edit User',
                'management' => 'User Management',
                'no_permissions' => 'No Permissions',
                'no_roles' => 'No Roles to set.',
                'permissions' => 'Permissions',
                'user_actions' => 'User Actions',

                'table' => [
                    'confirmed' => 'Confirmed',
                    'created' => 'Created',
                    'email' => 'E-mail',
                    'id' => 'ID',
                    'last_updated' => 'Last Updated',
                    'name' => 'Name',
                    'first_name' => 'First Name',
                    'last_name' => 'Last Name',
                    'no_deactivated' => 'No Deactivated Users',
                    'no_deleted' => 'No Deleted Users',
                    'other_permissions' => 'Other Permissions',
                    'permissions' => 'Permissions',
                    'abilities' => 'Abilities',
                    'roles' => 'Roles',
                    'social' => 'Social',
                    'total' => 'user total|users total',
                ],

                'tabs' => [
                    'titles' => [
                        'overview' => 'Overview',
                        'history' => 'History',
                    ],

                    'content' => [
                        'overview' => [
                            'avatar' => 'Avatar',
                            'confirmed' => 'Confirmed',
                            'created_at' => 'Created At',
                            'deleted_at' => 'Deleted At',
                            'email' => 'E-mail',
                            'last_login_at' => 'Last Login At',
                            'last_login_ip' => 'Last Login IP',
                            'last_updated' => 'Last Updated',
                            'name' => 'Name',
                            'first_name' => 'First Name',
                            'last_name' => 'Last Name',
                            'status' => 'Status',
                            'timezone' => 'Timezone',
                        ],
                    ],
                ],

                'view' => 'View User',
            ],

            'categories' => [
                'all' => 'All Categories',
                'active' => 'Category List',
                'create' => 'Create Category',
                'deactivated' => 'Deactivated Category',
                'deleted' => 'Deleted Category',
                'delete' => 'Delete Category',
                'edit' => 'Edit Category',
                'management' => 'Categories Management',
                'permission'=>'Permission',
                'log'=>'Information Log',
                'addpermission'=>'Add Permission',
                'table' => [
                    'created' => 'Created',
                    'id' => 'ID',
                    'last_updated' => 'Last Updated',
                    'name' => 'Category Name',
                    'createdby' => 'Created By',
                    'editedby' => 'Edited By',
                    'sharedby' => 'Shared By',
                    'removedby'=>'Removed By',
                    'grantedby' => 'Permissions Granted By',
                    'createdat' => 'Created At',
                    'parentcategory' => 'Parent Category',
                    'total' => 'categories total|categories total',
                ],
            ],

            'documents' => [
                'all' => 'All Documents',
                'create' => 'Create Document',
                'delete' => 'Delete Document',
                'edit' => 'Edit Document',
                'update_version' => 'Update Version',
                'management' => 'Document Management',

                'table' => [
                    'created' => 'Created',
                    'id' => 'ID',
                    'serial_number'=>'Serial Number',
                    'file_name'=>'Name',
                    'file_type'=>'Type',
                    'category'=>'Category',
                    'size'=>'Size',
                    'size_s3'=>'Size On Server',
                    'createdby' => 'Created By',
                    'owner'=>'Owner',
                    'version' => 'Version',
                    'url'=>'URL',
                    'expiration_date'=>'Expiration Date',
                    'last_updated' => 'Last Updated',
                    'createdat' => 'Created At',
                    'total' => 'Documents total|Documents total',
                    'version' =>'Version',
                ],
            ],


        ],
    ],

    'frontend' => [
        'auth' => [
            'login_box_title' => 'Login',
            'login_button' => 'Login',
            'login_with' => 'Login with :social_media',
            'register_box_title' => 'Register',
            'register_button' => 'Register',
            'remember_me' => 'Remember Me',
        ],

        'contact' => [
            'box_title' => 'Contact Us',
            'button' => 'Send Information',
        ],

        'passwords' => [
            'expired_password_box_title' => 'Your password has expired.',
            'forgot_password' => 'Forgot Your Password?',
            'reset_password_box_title' => 'Reset Password',
            'reset_password_button' => 'Reset Password',
            'update_password_button' => 'Update Password',
            'send_password_reset_link_button' => 'Send Password Reset Link',
        ],

        'user' => [
            'passwords' => [
                'change' => 'Change Password',
            ],

            'profile' => [
                'avatar' => 'Avatar',
                'created_at' => 'Created At',
                'edit_information' => 'Edit Information',
                'email' => 'E-mail',
                'last_updated' => 'Last Updated',
                'name' => 'Name',
                'first_name' => 'First Name',
                'last_name' => 'Last Name',
                'update_information' => 'Update Information',
            ],
        ],
    ],
];
