<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Menus Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used in menu items throughout the system.
    | Regardless where it is placed, a menu item can be listed here so it is easily
    | found in a intuitive way.
    |
    */

    'backend' => [
        'access' => [
            'title' => 'Access',

            'roles' => [
                'all' => 'All Roles',
                'create' => 'Create Role',
                'edit' => 'Edit Role',
                'management' => 'Role Management',
                'main' => 'Roles',
            ],

            'users' => [
                'all' => 'All Users',
                'active' => 'Active Users',
                'change-password' => 'Change Password',
                'create' => 'Create User',
                'deactivated' => 'Deactivated Users',
                'deleted' => 'Deleted Users',
                'edit' => 'Edit User',
                'main' => 'Users',
                'view' => 'View User',
            ],

            'permissions' => [
                'all' => 'All Permissions',
                'create' => 'Create Permission',
                'deactivated' => 'Deactivated Permission',
                'deleted' => 'Deleted Permissions',
                'edit' => 'Edit Permission',
                'main' => 'Permissions',
                'view' => 'View Permission',
                'management' => 'Permission Management',
            ],
            'usercategory' => [
                'user_category'=>'Category Users'
            ],
            'userdocument' => [
                'user_document'=> 'Document Users '
            ],
            'categories' => [
                'all' => 'All Categories',
                'active' => 'Active Categories',
                'create' => 'Create Category',
                'deactivated' => 'Deactivated Categories',
                'deleted' => 'Deleted Categories',
                'edit' => 'Edit Category',
                'main' => 'Categories',
                'view' => 'View Category',
                'delete' => 'Delete Category',
            ],


            'documents' => [
                'all' => 'All Documents',
                'create' => 'Create Document',
                'deleted' => 'Deleted Documents',
                'edit' => 'Edit Document',
                'view' => 'View Document',
                'delete' => 'Delete Document',
            ],

        ],



        'sidebar' => [
            'dashboard' => 'Dashboard',
            'general' => 'General',
            'history' => 'History',
            'system' => 'System',
            'categories' => 'Categories Management',
            'logs'=>'Logs Management',
            'documents' => 'Document Management',
            'document' => 'Document',
            'documentreport' => 'Document Report',
            'documentfilter' => 'Document Filter',
            'logfilter' => 'Logs Filter',
            'notifications'=>'Notifications',
            'settings'=>'Settings',
        ],
    ],

    'language-picker' => [
        'language' => 'Language',
        /*
         * Add the new language to this array.
         * The key should have the same language code as the folder name.
         * The string should be: 'Language-name-in-your-own-language (Language-name-in-English)'.
         * Be sure to add the new language in alphabetical order.
         */
        'langs' => [
            'ar' => 'عربى (Arabic)',
            'en' => 'English',
        ],
    ],
];
