<div class="card-body">
    <div class="row">
        <div class="col-sm-5">
            <h4 class="card-title mb-0">
                {{ __('labels.backend.access.categories.management') }}
                <small class="text-muted">{{ (isset($category)) ? __('labels.backend.access.categories.edit') : __('labels.backend.access.categories.create') }}</small>
            </h4>
        </div>
        <!--col-->
    </div>
    <!--row-->

    <hr>
    {{ Form::hidden('categoryid', isset($category) ?$category->id :'',['id' => 'categoryid']) }}

    <div class="row mt-4 mb-4">
        <div class="col">
            <div class="form-group row">
                {{ Form::label('name', trans('validation.attributes.backend.access.categories.name'), ['class' => 'col-md-2 from-control-label required']) }}

                <div class="col-md-10">
                    {{ Form::text('name', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.access.categories.name'), 'required' => 'required']) }}
                </div>
                <!--col-->
            </div>
            <!--form-group-->
            <div class="form-group row">
                {{ Form::label('categories', trans('validation.attributes.backend.access.categories.parent_category'), ['class' => 'col-md-2 from-control-label required']) }}

                <div class="col-md-10">
                    @if(!empty($selectedCategories))
                    {{ Form::hidden('parentcategory', isset($selectedCategories) ?$selectedCategories :'',['id' => 'parentcategory']) }}
                    {{ Form::select('categories', isset($selectedCategories) ?['' => 'Select Category'] +$Categories :['' => 'Select Category'] , null, ['class' => 'form-control categories1 box-size', 'data-placeholder' => trans('validation.attributes.backend.access.categories.parent_category') ]) }}
                    @else
                    {{ Form::hidden('parentcategory', isset($parentcategory) ? $parentcategory:'',['id' => 'parentcategory']) }}
                    {{ Form::select('categories',isset($parentcategory) ?['' => 'Select Category'] +$Categories :['' => 'Select Category']  , null, ['class' => 'form-control categories1 box-size', 'data-placeholder' => trans('validation.attributes.backend.access.categories.parent_category')]) }}
                    @endif
                </div>
                <!--col-->
            </div>
            <!--form-group-->


        </div>
        <!--col-->
    </div>
    <!--row-->
</div>
<!--card-body-->

@section('pagescript')
<script type="text/javascript">
    FTX.Utils.documentReady(function() {
        FTX.Categories.edit.init("{{ config('locale.languages.' . app()->getLocale())[1] }}");
    });
    $(function(){

        $('.categories1').select2({
            width: '100%',
            minimumInputLength: 2,
            allowClear: true,
            ajax: {
                url: "{{ route('admin.categories.search') }}",
                dataType: 'json',
                data: function(params) {
                    return {
                        q: params.term.trim(),
                        name:$('input[name="name"]').val(),
                        categoryid:$('input[name="categoryid"]').val()
                    };
                },
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                error: function(err) {
                    console.log(err);
                },
                cache: true
            },
            templateResult: function(data) {
                if (!data.subtitle) {
                    return data.text;
                }
                return $('<span>').html(data.text + '<br><small style="color:grey;">' + data.subtitle + '</small>');
            }
        });

        });
</script>
@stop
