@extends('backend.layouts.app')

@section('title', app_name() . ' | ' . __('labels.backend.access.categories.management'))

@section('content')
    @if (session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif
    <div class="row doc-section">
        <div class="tree-col col-lg-3 col-md-4 col-sm-12 col-12 pl-0  pr-0 
        {{ str_replace('_', '-', app()->getLocale()) == 'ar' ? 'pr-md-0' : 'pl-md-0';  }} ">
            <div class="input-with-icon p-3">
                <div class="search-section mr-2">
                   <div class="input-group " style=" border-radius: 30px;">
                        <input class="form-control py-2 border-right-0 border " type="search" value="search" id="search-input">
                        <span class="input-group-append">
                          <button class="btn btn-outline-secondary border-left-0 border" type="button">
                                <i class="fa fa-search"></i>
                          </button>
                        </span>
                    </div>
                </div>
                <div class="create_cat">
                    <a class=" create_category_root btn grid"  href="{{ route('admin.categories.create', ['categoryid' => $rootId ]) }}" target="_blank" rel="noopener noreferrer"
                        @unless($logged_in_user->isAdministrator() || $logged_in_user->isAdmin()) style="display: none;" @endunless><i class="fas fa-plus"></i></a>

                </div>
            </div>
              <div id="treeDemoWrapper" class='hide-on-mobile bt-grey {{ str_replace('_', '-', app()->getLocale()) == 'ar' ? ' mr-2' : 'ml-2' }} '>
                    <div id="treeDemo">
                        <ul>
                            <li>
                                <i class="fa-solid fa-folder-open"></i>
                            </li>
                            @foreach ($roots as $root)
                                <li>{{$root->name}}</li>
                            @endforeach
                        </ul>
                    </div>
             </div>
        </div>
        <div class="table-col col-lg-7 col-md-6 col-sm-12 col-12 px-0 ">
            <div class="table-wrapper table-responsive-sm table-responsive-custom">
            <div class="tables" >
                <div class="header">
                    <div class="header-name"></div>
                        <button class="btn list active" ><i class="fa fa-bars"></i> </button>
                        <button class="btn grid" ><i class="fa fa-th-large"></i> </button>
                </div>
                    <div class="options-list mt-2" style="display: none;">
                        <span class="close-select px-3" title="Clear Selection">&times;</span>
                        <div class="num-items"></div>
                        <div class="item-list delete_doc pl-3 "@unless($logged_in_user->isAdministrator() || $logged_in_user->isAdmin()) style="display: none;" @endunless>
                            <button type="button"  class="btn delete_doc"
                            data-trans-button-cancel="{{trans('buttons.general.cancel')}}"
                            data-trans-button-confirm="{{trans('buttons.general.crud.delete')}}"
                            data-trans-title="{{trans('strings.backend.general.are_you_sure')}}">
                            <i data-toggle="tooltip" data-placement="top" title="{{ trans('buttons.general.crud.delete')}}" class="fa fa-trash "></i>
                             </button>
                            </div>
                            <div class="item-list download-multi">
                                <a href="{{ route('admin.downloadMultipleFiles', 'category') }}" class="btn download-multi"><i class="fas fa-download "></i></a>
                            </div>

                            @if(session()->has('access_token') && time() < session('access_token_expires'))
                        <!-- If access token exists and is not expired, show the send email button -->
                        <div class="item-list send-email" id="send-emaill" >
                            <a href="{{ route('admin.sendEmail') }}" class="btn send-email" id="sendEmailButton" style="display: none;" data-toggle="modal" data-target="#sendEmailModal">
                                <i class="fas fa-envelope"></i>
                            </a>
                        </div>
                        <div class="item-list view-file">
                            <button class="btn upload-files" onclick="getFileOnlineLinkAndOpen()" id="view-file" name="view-file" style="display: none;">
                                <i class="fas fa-book-open"></i> Open File Online
                            </button>
                        </div>

                    @endif
                </div>

                                    <!-- Send Email Modal -->
                                <div class="modal fade" id="sendEmailModal" tabindex="-1" role="dialog"
                                    aria-labelledby="sendEmailModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="sendEmailModalLabel">Send Email</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <!-- Form fields for To, Subject, Body, and Attachments -->
                                                <form id="sendEmailForm" method="POST" action="{{ route('admin.sendEmail') }}">
                                                    @csrf
                                                    <div class="form-group">
                                                        <label for="emailTo">To:</label>
                                                        <input type="email" class="form-control" id="emailTo" name="emailTo"
                                                            required>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="emailSubject">Subject:</label>
                                                        <input type="text" class="form-control" id="emailSubject" name="emailSubject"
                                                            required>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="emailBody">Body:</label>
                                                        <textarea id="emailBody" name="emailBody" class="form-control" ></textarea>
                                                    </div>
                                                    <div class="form-group">

                                                        <input type="hidden" class="form-control-file" id="document-id"
                                                            name="document-id">
                                                    </div>


                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                <button type="submit" class="btn btn-primary" id="sendEmailBtn">Send Email</button>
                                            </div>
                                            </form>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- End Send Email Modal -->


                    <div class="data-container" id="cat-table" data-ajax_url="{{ route("admin.categories.get") }}" data-category-id="{{ request()->get('categoryid')??'' }}"  >
                    <ul class="data-list ">
                        <li class="header">
                          <span class="serial_number">{{ trans('labels.backend.access.documents.table.serial_number') }}</span>
                          <span class="icon">&nbsp;</span>
                          <span class="namehead">{{ trans('labels.backend.access.documents.table.file_name') }}</span>
                          <span class="type">{{ trans('labels.backend.access.documents.table.file_type') }}</span>
                          <span class="category">{{ trans('labels.backend.access.documents.table.category') }}</span>
                          <span class="version">{{ trans('labels.backend.access.documents.table.version') }}</span>
                          <span class="icon">&nbsp;</span>
                          <span class="owner">{{ trans('labels.backend.access.documents.table.owner') }}</span>
                          <span class="option"></span>
                          </li>
                            <!-- Skeleton Loader (More Structured) -->
                       <div class="ssc-wrapper" id="tableSkeleton">
                        <table class="ssc-table">
                          <!-- Table Header -->
                          <thead>
                            <tr>
                              <th><div class="ssc-line w-90"></div></th>
                              <th><div class="ssc-line w-90"></div></th>
                              <th><div class="ssc-line w-90"></div></th>
                              <th><div class="ssc-line w-90"></div></th>
                              <th><div class="ssc-line w-90"></div></th>
                              <th><div class="ssc-line w-90"></div></th>
                            </tr>
                          </thead>

                          <!-- Table Body -->
                          <tbody>
                            <tr>
                              <td><div class="ssc-line w-90"></div></td>
                              <td><div class="ssc-line w-90"></div></td>
                              <td><div class="ssc-line w-90"></div></td>
                              <td><div class="ssc-line w-90"></div></td>
                              <td><div class="ssc-line w-90"></div></td>
                              <td><div class="ssc-line w-90"></div></td>
                            </tr>
                            <tr class="ssc-row-divider"></tr>

                            <tr>
                              <td><div class="ssc-line w-90"></div></td>
                              <td><div class="ssc-line w-90"></div></td>
                              <td><div class="ssc-line w-90"></div></td>
                              <td><div class="ssc-line w-90"></div></td>
                              <td><div class="ssc-line w-90"></div></td>
                              <td><div class="ssc-line w-90"></div></td>
                            </tr>
                            <tr class="ssc-row-divider"></tr>

                            <tr>
                              <td><div class="ssc-line w-90"></div></td>
                              <td><div class="ssc-line w-90"></div></td>
                              <td><div class="ssc-line w-90"></div></td>
                              <td><div class="ssc-line w-90"></div></td>
                              <td><div class="ssc-line w-90"></div></td>
                              <td><div class="ssc-line w-90"></div></td>
                            </tr>
                            <tr class="ssc-row-divider"></tr>
                          </tbody>
                        </table>
                    </div>
                      </ul>
                        <hr class="hr-footer">
                    </div>
           </div>
            </div>
        </div>
        <div class="col-lg-2 col-md-4 col-sm-12 col-12" 
        style="{{ str_replace('_', '-', app()->getLocale()) == 'ar' ? 'padding-left:0px;' : 'padding-right:0px;' }} ">
{{--            <div class="log-section" >--}}
{{--                <span class="close-btn">&times;</span>--}}
                <div class="content" style="display: none;">
                <a data-fancybox="gallery" href="#" class="d-flex cat-section pl-2 pt-2">

                    <img class="attachment-thumbnail" style="width: 45px;height: auto;padding: 2px;object-fit:contain;margin-right:3px;" src="">
                        <div class="categoryname">
                        </div>
                </a>

                <ul class="nav tabs pt-3" id="myTab" role="tablist">
                    <li class="nav-item pr-1">
                      <a class="nav-link active " id="details-tab" data-toggle="tab" href="#details" role="tab" aria-controls="details" aria-selected="true">Details</a>
                    </li>
                    <li class="nav-item pl-1">
                      <a class="nav-link" id="activity-tab" data-toggle="tab" href="#activity" role="tab" aria-controls="activity" aria-selected="false">Activity</a>
                    </li>
                </ul>
                 <hr class="hr-logs">
                 <!-- Skeleton Loader -->
            <div class="ssc-wrapper" id="logSkeleton">

                <div class="ssc-tab-content">
                    <div class="ssc-title"></div>
                    <div class="ssc-detail">
                        <span class="ssc-label"></span>
                        <span class="ssc-value"></span>
                    </div>
                    <div class="ssc-detail">
                        <span class="ssc-label"></span>
                        <span class="ssc-value"></span>
                    </div>
                    <div class="ssc-detail">
                        <span class="ssc-label"></span>
                        <span class="ssc-value"></span>
                    </div>
                    <div class="ssc-detail">
                        <span class="ssc-label"></span>
                        <span class="ssc-value"></span>
                    </div>
                </div>
            </div>
                <div class="tab-content" id="logDetails" style="display: none;">
                    <div class="tab-pane fade show active" id="details">
                        <h5>File Details</h5>
                        <div class="file_details">
                            <div class="detail-section"><label>Type</label><span class="type-value"></span></div>
                            <div class="detail-section"><label>Size</label><span class="size-value"></span></div>
                            <div class="detail-section"><label>Owner</label><span class="owner-value"></span></div>
                            <div class="detail-section"><label>Modified</label><span class="modified-value"></span></div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="activity"></div>
                </div>
            </div>
        </div>

    </div>
</div>
    @include('backend.categories.includes.permissionModal', ['edit' => 'no'])
    @include('backend.categories.includes.ShareModal')
    @include('backend.categories.includes.OptionsMenu')
@endsection
@section('pagescript')
<script>
    $("#tree").jstree({
    'core': {
          "multiple": false,
    "animation": 200,
        'data': function (node, callback) {
            if (node.state.loaded) {  // إذا كانت العقدة محملة مسبقًا، لا تقم بإعادة تحميلها
                callback(node.children);
                return;
            }

            $('#logDetails').hide(); // Instantly hide details
            $('#logSkeleton').fadeIn(100);
            //$('.data-content').hide(); // Instantly hide details

            //   setTimeout(function () {  // تأخير جلب البيانات قليلاً

            $.ajax({
                'url': $('meta[name="root-url"]').attr('content'),
                'data': { 'id': node.id },
                'dataType': 'json',
                'success': function (data) {
                    data.forEach(function (item) {
                        if (item.status === 1) {
                            item.text += " <i class='fas fa-link text-primary'></i>";
                        }
                    });

                    if (data.length > 10) {
                        let visibleNodes = data.slice(0, 10);

                        // Add "Show More" button
                        visibleNodes.push({
                            "id": node.id + "_separator",  // Unique ID for each parent
                            "parent": node.id,
                            "text": "<span class='show-more' data-node='" + node.id + "'><b>⋯</b></span>",
                            "icon": false,
                            "state": { "disabled": true }
                        });
                        callback(visibleNodes);
                    } else {
                        callback(data);
                        console.log(node.state, node.children)

                    }
                    $('#logSkeleton').hide(); // Instantly hide skeleton
                    $('#logDetails').fadeIn(100);
                    $('#tableSkeleton').hide();

                },
                'error': function (xhr, status, error) {
                    console.error("Error fetching data:", error);
                    $('#logSkeleton').hide(); // Instantly hide skeleton
                    $('#logDetails').fadeIn(100);
                    $('#tableSkeleton').hide();

                }
            });
            // },50)
        }
    },
    "themes": {
        dots: false,
        "icons": false,
        "variant": "large",
        "responsive": true
    },
    "types": {
        "default": {
            "icon": "ki-outline ki-older"
        },

    },
    "search": {
        "case_sensitive": false,
        "show_only_matches": true
    },
    
    "plugins": ["changed", "themes", "types", "search","ui","wholerow"]
});
 $('#tree').on("click", ".jstree-anchor", function (e) {
        let instance = $.jstree.reference(this);
        let node = instance.get_node(this);
        var parent = $(this).closest("li");

        console.log("1", node.state);
       
             
        setTimeout(function () {
            if (node.state.opened) {
                instance.close_node(node);
                console.log("2", node.state);
            } else {
                instance.open_node(node);
                console.log("3", node.state);
            }

            if (parent.hasClass("jstree-last")) {
                //    console.log("ewewwew");
                parent.find(".jstree-node").each(function () {
                    $(this).addClass("jstree-closed");
                });
            }
        }, 100);
    });
</script>
 <script>
        FTX.Utils.documentReady(function() {
            FTX.Categories.list.init();
            FTX.Categories.edit.init();
            FTX.Categories.edit.selectors.getuserCategoryURL = "{{ route('admin.checkUserCategory') }}";
            FTX.Categories.edit.selectors.giveuserCategoryURL = "{{ route('admin.giveUserCategory') }}";
            FTX.Categories.edit.selectors.getuserDocumentURL = "{{ route('admin.checkUserDocument') }}";
            FTX.Categories.edit.selectors.giveuserDocumentURL = "{{ route('admin.giveUserDocument') }}";
            FTX.Categories.edit.selectors.getcategorypathURL = "{{ route('admin.getcategorypath') }}";
            FTX.Categories.edit.selectors.createcategoryURL =
                "{{ route('admin.categories.create', ['categoryid' => '']) }}";
            FTX.Categories.edit.selectors.categoryUserURL =
                "{{ route('admin.categorypermission', ['category_id' => '']) }}";
            FTX.Categories.edit.selectors.documentUserURL =
                "{{ route('admin.documentpermission', ['document_id' => '']) }}";
            FTX.Categories.edit.selectors.getHistoryUrl =
                "{{ route('admin.documents.getHistory') }}";
            FTX.Categories.edit.selectors.createdocumentURL =
                "{{ route('admin.documents.create', ['categoryid' => '']) }}";
            FTX.Categories.edit.selectors.editcategoryURL = "{{ route('admin.categories.edit', 'category') }}";
            FTX.Categories.edit.selectors.editdocURL = "{{ route('admin.documents.edit', 'category') }}";
            FTX.Categories.edit.selectors.deletecategoryURL =
                "{{ route('admin.categories.destroy', ['category' => 'categoryId']) }}";
            FTX.Categories.edit.selectors.deletedocURL =
                "{{ route('admin.documents.destroy', ['document' => 'categoryId']) }}";
            FTX.Categories.edit.selectors.deletefiles =
                "{{ route('admin.delete_files', ['Categoryids' => 'categoryids']) }}";
            FTX.Categories.edit.selectors.shareURL = "{{ route('admin.share') }}";
            FTX.Categories.edit.selectors.getlogURL = "{{ route('admin.logs.getlog') }}";
            FTX.Categories.edit.selectors.downloadcategoryURL =
                "{{ route('admin.download-zip', ['categoryid' => '']) }}";
            FTX.Categories.edit.selectors.downloadMultipleFilesURL =
                "{{ route('admin.downloadMultipleFiles', ['Categoryids' => 'categoryids']) }}";

            FTX.Categories.edit.selectors.downloadMultipleFilesURL =
                "{{ route('admin.sendEmail', ['Categoryids' => 'categoryids']) }}";
            FTX.Categories.edit.selectors.downloadcategoryURL = "{{ route('admin.upload.file', ['categoryid' => '']) }}";
            FTX.EmailSender.list.init();
        });
    </script>

@endsection

@push('before-styles')

    <meta name="root-url" content="{{ route('admin.categories.tree') }}">
    <meta name="sendEmail-url" content="{{ route('admin.sendEmail') }}">
    <meta name="upload-file-url" content="{{ route('admin.upload.file') }}">
    <link rel="stylesheet" href="{{ asset('vendors/vakata-jstree-b3135cf/dist/themes/default/style.min.css') }}">
@endpush

@push('after-scripts')
    <script src="{{ asset('vendors/vakata-jstree-b3135cf/dist/jstree.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="{{ asset('js/backend/emailSender.js') }}"></script>
    <script src="{{ asset('js/backend/openFilesOnline.js') }}"></script>
@endpush

@push('after-styles')
    <link rel="stylesheet" href="{{ asset('css/category.css') }}?v4.2">
    <link rel="stylesheet" href="{{ asset('vendors/skeleton-screen-css-master/dist/index.min.css') }}">
@endpush
