@extends('backend.layouts.app')

@section('title', app_name() . ' | '. __('labels.backend.access.userdocument.user_document'))


@section('content')
<div class="card">
    <div class="card-body">
        <div class="row mb-2">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    @lang('labels.backend.access.userdocument.user_document')
                </h4>
            </div>
            <!--col-->
        </div>
        <!--row-->
        <div class="row">


              @foreach ($users as $user)
              <div class="col-md-4 my-2" style="margin-left: 8rem !important;">
                <div class="card card2">
                  <div class="list list-item">
                      <img src="{{ $user->picture }}" class="img-card">
                      <div class="list-item-content">
                        <h4 >{{$user->name}}</h4>
                      </div>
                      <a href="{{ route('admin.deletedocumentuser',['document_id' => $document_id ,'user_id'=>$user->id ])}}" class="delete-button" data-method="delete" data-trans-button-cancel="{{trans('buttons.general.cancel')}}" data-trans-button-confirm="{{trans('buttons.general.crud.delete')}}" data-trans-title="{{trans('strings.backend.general.are_you_sure')}}">
                        <i data-toggle="tooltip" data-placement="top" title="{{ trans('buttons.general.crud.delete')}}" class="fa fa-times"></i>
                      </a>
                      <button class="btn edit-button editpermissiondocument" data-toggle="modal" data-target="#permissiondocumentModal"  data-document="{{ $document_id }}" data-user="{{ $user->id }}" data-username="{{ $user->full_name }}"><i class="fas fa-edit "></i></button>
                    </div>

                </div>
              </div>
              @endforeach
          </div>
               <!--row-->
    </div>
    <!--card-body-->
</div>
<!--card-->
@include('backend.categories.includes.permissionModal', [ 'edit' => 'yes'])
@endsection
@section('pagescript')
<script>
     FTX.Utils.documentReady(function() {
        FTX.Categories.edit.init();
        FTX.Categories.edit.selectors.edituserDocumentURL = "{{ route('admin.editUserDocument') }}";
        FTX.Categories.edit.selectors.getuserDocumentURL = "{{ route('admin.checkUserDocument') }}";

    });
</script>
@endsection


@push('after-styles')

{{ style(asset('css/view.css')) }}

@endpush
