@extends('backend.layouts.app')

@section('title', app_name() . ' | ' . __('labels.backend.access.documents.management'))

@section('breadcrumb-links')
@include('backend.documents.includes.breadcrumb-links')
@endsection

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    {{ __('labels.backend.access.documents.management') }}
                </h4>
            </div>
            <!--col-->
        </div>
        <!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table id="documents-table" class="table" data-ajax_url="{{ route("admin.documents.get") }}">
                        <thead>
                            <tr>
                                <th>{{ trans('labels.backend.access.documents.table.serial_number') }}</th>
                                <th>{{ trans('labels.backend.access.documents.table.file_name') }}</th>
                                <th>{{ trans('labels.backend.access.documents.table.file_type') }}</th>
                                <th>{{ trans('labels.backend.access.documents.table.category') }}</th>
                                <th>{{ trans('labels.backend.access.documents.table.url') }}</th>
                                <th>{{ trans('labels.backend.access.documents.table.createdat') }}</th>
                                <th>{{ trans('labels.general.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
            <!--col-->
        </div>
        <!--row-->

    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection

@section('pagescript')
<script>
    FTX.Utils.documentReady(function() {
        FTX.Documents.list.init();
    });
</script>

@stop
