<?php
$darkModeSettings = \App\Models\UserMeta::Preferences(auth()->user(), \App\Models\UserMeta::DARK_MODE);

$dark_mode = isset($darkModeSettings) && isset($darkModeSettings['dark_mode']) && $darkModeSettings['dark_mode'] == "YES" ? true : false;
$font_size = \App\Models\UserMeta::where("user_id", auth()->id())->where("name", \App\Models\UserMeta::THEME_FONT)->first()?->value;
?>
<!DOCTYPE html>
@langrtl
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl">
@else
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
@endlangrtl

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', app_name())</title>
    <meta name="description" content="@yield('meta_description', 'Laravel Starter')">
    <meta name="author" content="@yield('meta_author', 'FasTrax Infotech')">
    <meta name="view" content="{{ App\Models\Category::VIEW }}">
    <meta name="edit" content="{{ App\Models\Category::EDIT }}">
    <meta name="delete" content="{{ App\Models\Category::DELETE }}">
    <meta name="create" content="{{ App\Models\Category::CREATE }}">
    <meta name="share" content="{{ App\Models\Category::SHARE }}">
     <meta id="mode-style-url" content="{{ asset('css/dark-mode.css') }}?v7.221.367">
   

    @yield('meta')

    {{-- See https://laravel.com/docs/5.5/blade#stacks for usage --}}
    @stack('before-styles')

    <!-- Check if the language is set to RTL, so apply the RTL layouts -->
    <!-- Otherwise apply the normal LTR layouts -->
    {{ style(mix('css/backend.css')) }}

    <link rel="stylesheet" href="https://netdna.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/boxicons/2.1.4/css/animations.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/boxicons/2.1.4/css/boxicons.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/boxicons/2.1.4/css/transformations.min.css">
    <link rel="stylesheet" href="{{asset('css/backend.css')}}?v2">
    <link rel="stylesheet" href="{{asset('css/app.css')}}?v2">
     <link rel="stylesheet" href="{{asset('css/sidebarx.css')}}?v3">

@if($dark_mode)
    <link id="dark-style"  href="{{ asset('css/dark-mode.css') }}?v7.221.367"  rel="stylesheet">
@endIf
     @stack('after-styles')
    <style>
        .hidden {
            display: none !important;
        }
    </style>
</head>

{{--
     * CoreUI BODY options, add following classes to body to change options
     * // Header options
     * 1. '.header-fixed'					- Fixed Header
     *
     * // Sidebar options
     * 1. '.sidebar-fixed'					- Fixed Sidebar
     * 2. '.sidebar-hidden'				- Hidden Sidebar
     * 3. '.sidebar-off-canvas'		    - Off Canvas Sidebar
     * 4. '.sidebar-minimized'			    - Minimized Sidebar (Only icons)
     * 5. '.sidebar-compact'			    - Compact Sidebar
     *
     * // Aside options
     * 1. '.aside-menu-fixed'			    - Fixed Aside Menu
     * 2. ''			    - Hidden Aside Menu
     * 3. '.aside-menu-off-canvas'	        - Off Canvas Aside Menu
     *
     * // Breadcrumb options
     * 1. '.breadcrumb-fixed'			    - Fixed Breadcrumb
     *
     * // Footer options
     * 1. '.footer-fixed'					- Fixed footer
--}}

<body class="app @if($dark_mode) dark-theme @endIf header-fixed sidebar-fixed aside-menu-off-canvas sidebar-lg-show" style="font-size:{{ $font_size ?? '14px' }} ">
  
    @include('backend.includes.header')

    <div class="wrapper sidebar-collapse app-body" >

        @include('backend.includes.sidebar')

        <main class="main">
            @include('includes.partials.read-only')
            @include('includes.partials.logged-in-as')
            {!! Breadcrumbs::render() !!}

            <div class="container-fluid pt-3">
                <div class="animated fadeIn">
                    <div class="content-header">
                        @yield('page-header')
                    </div>
                    <!--content-header-->

                    @include('includes.partials.messages')
                    @yield('content')
                </div>
                <!--animated-->
            </div>
            <!--container-fluid-->
        </main>
        <!--main-->

        @include('backend.includes.partials.theme_sidebar', [
  'dark_mode' => $dark_mode,
  'font_size' => $font_size,
])
        @include('backend.includes.aside') 
    </div>
    <!--app-body-->

    @include('backend.includes.footer')

    <!-- Scripts -->
    @stack('before-scripts')
    {!! script(mix('js/manifest.js')) !!}
    {!! script(mix('js/vendor.js')) !!}
    {!! script(mix('js/backend.js')) !!}
    <script src="{{ asset('/js/tinymce/tinymce.min.js')}}"></script>
    {!! script(asset('js/backend/common.js')) !!}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-cookie/1.4.1/jquery.cookie.min.js"></script>
    {!! script(asset('js/backend/app.js'), [], null,'532024') !!}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/boxicons/2.1.4/dist/boxicons.js"></script>

    @isset($js)
    @foreach($js as $j)
    {!! script(asset('js/backend/'. $j. '.js'), [], null,'2422024') !!}
    @endforeach
    @endif
<script>
    $(".reset-default").on("click", function () {
  var url = $(this).attr("data-url");
  let fontSize = "14px";
  $("body").css("font-size", fontSize);
  $(".slider-point").each(function(){
    $(this).removeClass("active");
    if ($(this).data("value") == fontSize){
      $(this).addClass("active");
    }
  });
  if ($.fn.DataTable.isDataTable(".datatable-full")) {
    table.destroy();  // تدمير الجدول الحالي
  }

  table = $(".datatable-full").DataTable(tableOptions);

  $(".change-mode").each(function(){
    $(this).removeClass("active");
    if ($(this).data("mode") == "light"){
      $(this).addClass("active");
    }
  });
  $("body").removeClass("dark-theme");
    $("#dark-style").remove();
    $('.dynamic-chart,.chart').removeClass("highcharts-dark");
  $('img.parent-sub').each(function () {
    let currentSrc = $(this).attr('src').split('/');
    let fileName = currentSrc.pop().replace("dark-", "");;
    let path = currentSrc.join('/');
    let newImg = fileName;
    $(this).attr('src', path + "/" + newImg);
  });
  $.get(url)
    .done(function (data) {

    }).fail(function (xhr) {
      alert(xhr.responseJSON.message);
    });

});
$(".slider-point").on("click", function () {
    $(".slider-point").removeClass("active");
    $(this).addClass("active");
    console.log("ewew");
    let fontSize = $(this).data("value");
    let url = $(this).parent().data("url");
      console.log(url);
    $("body").css("font-size", fontSize);
    $("table").find("td,th").each(function () {
      $(this).removeClass("sticky-column");
      $(this).removeClass("last-sticky");
      $(this).css('left', '0px');
    });
    if ($.fn.DataTable.isDataTable(".datatable-full")) {
      table.destroy();  // تدمير الجدول الحالي
      table = $(".datatable-full").DataTable(tableOptions);
    }



    $.post(url, { _token: $('meta[name="csrf-token"]').attr('content'), font: fontSize }).done(function () {
    }).fail(function () {
    });
  });
$(".change-mode").on("click", function () {
  var url = $(this).attr("data-url");
  var mode = $(this).attr("data-mode");
  $(".change-mode").removeClass("active");
  $(this).addClass("active");
  if (mode == "dark") {
    var styleUrl = $("#mode-style-url").attr("content");
    if($("#dark-style").length == 0){
    $("head").append('<link id="dark-style"  href="' + styleUrl + '"  rel="stylesheet">');
    }
    $('.dynamic-chart,.chart').addClass("highcharts-dark");
    $("body").addClass("dark-theme");
  } else {
    $("#dark-style").remove();

    $('.dynamic-chart,.chart').removeClass("highcharts-dark");
    $("body").removeClass("dark-theme");
  }

  $('img.parent-sub').each(function () {
    let currentSrc = $(this).attr('src').split('/');
    let fileName = currentSrc.pop().replace("dark-", "");;
    let path = currentSrc.join('/');
    let newImg = mode == "dark" ? "dark-" + fileName : fileName;
    $(this).attr('src', path + "/" + newImg);
  });
  $.get(url)
    .done(function (data) {

    }).fail(function (xhr) {
      alert(xhr.responseJSON.message);
    });

});

</script>
    @stack('after-scripts')

    @yield('pagescript')
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

  </body>

</html>
