@extends('backend.layouts.app')
@section('title', app_name() . ' | Account settings' )

@section('content')
<div class="page-settings">
    <div class="row justify-content-center align-items-center mb-3">
        <div class="col col-sm-20 align-self-center">
            <div class="card">
                <div class="card-header">
                    <strong>
                        @lang('navs.frontend.user.account')
                    </strong>
                </div>
                <div class="card-body">
                    <div class="container light-style flex-grow-1 container-p-y">

                        <h4 class="font-weight-bold py-3 mb-4">
                            Account settings
                        </h4>

                        <div class="card overflow-hidden">
                            <div class="row no-gutters row-bordered row-border-light">
                                <div class="col-md-3 pt-0 border-right">
                                    <div class="list-group list-group-flush account-settings-links">
                                        <a class="list-group-item list-group-item-action active" data-toggle="list"
                                            href="#account-general">General</a>
                                        <a class="list-group-item list-group-item-action" data-toggle="list"
                                            href="#account-change-password">Change password</a>
                                        <a class="list-group-item list-group-item-action" data-toggle="list"
                                            href="#account-connections">Connections</a>
                                        <a class="list-group-item list-group-item-action" data-toggle="list"
                                            href="#account-storage">Storage</a>

                                    </div>
                                </div>
                                <div class="col-md-9">
                                    <div class="tab-content">
                                        <div class="tab-pane fade active show" id="account-general">
                                            {{ html()->modelForm($logged_in_user, 'POST', route('frontend.user.profile.update'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                                            @method('PATCH')

                                            <div class="card-body media align-items-center">

                                                <img src="{{ $logged_in_user->picture }}" class="user-profile-image" />
                                            </div>
                                         
                                            <div class="card-body">

                                                <div class="form-group">
                                                    {{ html()->label(__('validation.attributes.frontend.name'))->for('name') }}

                                                    {{ html()->text('name')->class('form-control')->placeholder(__('validation.attributes.frontend.name'))->attribute('maxlength', 191)->required()->autofocus() }}
                                                </div>





                                                <div class="form-group">
                                                    <label class="form-label">@lang('labels.frontend.user.profile.email')</label>
                                                    <input type="text" class="form-control mb-1"
                                                        value="{{ $logged_in_user->email }}" readonly>
                                                </div>

                                                @if ($logged_in_user->canChangeEmail())
                                                    <div class="form-group">
                                                        {{ html()->label(__('labels.frontend.user.profile.email'))->class('form-label') }}
                                                        {{ html()->email('email', $logged_in_user->email)->class('form-control mb-1')->attribute('readonly', true) }}
                                                    </div>
                                                @endif



                                            </div>
                                            <div class="text-right mt-3">
                                                {{ form_submit(__('labels.general.buttons.update')) }}

                                                {{ html()->closeModelForm() }}
                                                <button type="button" class="btn btn-default">Cancel</button>
                                            </div>
                                        </div>


                                        <div class="tab-pane fade" id="account-change-password">
                                            {{ html()->form('PATCH', route('frontend.auth.password.update'))->class('form-horizontal')->open() }}
                                            <div class="card-body pb-2">

                                                <div class="form-group">
                                                    {{ html()->label(__('validation.attributes.frontend.old_password'))->for('old_password') }}

                                                    {{ html()->password('old_password')->class('form-control')->placeholder(__('validation.attributes.frontend.old_password'))->autofocus()->required() }}
                                                </div>

                                                <div class="form-group">
                                                    {{ html()->label(__('validation.attributes.frontend.password'))->for('password') }}

                                                    {{ html()->password('password')->class('form-control')->placeholder(__('validation.attributes.frontend.password'))->required() }}
                                                </div>

                                                <div class="form-group">
                                                    {{ html()->label(__('validation.attributes.frontend.password_confirmation'))->for('password_confirmation') }}
                                                    {{ html()->password('password_confirmation')->class('form-control')->placeholder(__('validation.attributes.frontend.password_confirmation'))->required() }}
                                                </div>
                                                {{ form_submit(__('labels.general.buttons.update') . ' ' . __('validation.attributes.frontend.password')) }}
                                                {{ html()->form()->close() }}
                                            </div>

                                        </div>


                                        <div class="tab-pane fade" id="account-connections">
                                            <hr class="border-light m-2">
                                            @if (session()->has('access_token') && time() < session('access_token_expires'))
                                                <div class="card-body">
                                                    <h5 class="mb-2 d-flex align-items-center">
                                                        <p class="mb-2">You are connected to <i class="bi bi-windows"></i> Microsoft</p>
                                                    </h5>
                                                    <!-- Logout Button Section -->
                                                    <div class="d-flex align-items-center mb-2">
                                                        <a href="{{ route('frontend.auth.logout.microsoft') }}" class="btn btn-danger d-flex align-items-center">
                                                            <i class="bi bi-box-arrow-right mr-2"></i> Logout
                                                        </a>
                                                    </div>
                                                </div>
                                            @else
                                                <hr class="border-light m-0">
                                                <div class="card-body">
                                                    <p class="mb-2">You are not connected to <i class="bi bi-windows"></i> Microsoft</p>
                                                    <a href="{{ route('frontend.internal.redirect') }}" class="microsoft-login-button">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" class="mr-2">
                                                            <rect x="1" y="1" width="9" height="9" fill="#f25022" />
                                                            <rect x="1" y="11" width="9" height="9" fill="#00a4ef" />
                                                            <rect x="11" y="1" width="9" height="9" fill="#7fba00" />
                                                            <rect x="11" y="11" width="9" height="9" fill="#ffb900" />
                                                        </svg> Login with Microsoft
                                                    </a>
                                                </div>
                                            @endif
                                        </div>

                                        <div class="tab-pane fade" id="account-storage">
                                            <div class="card-body pb-2">
                                                <div class="form-group p-3">
                                                    <form action="#" method="POST">
                                                        @csrf
                                                        <div class="mb-4">
                                                            <label for="type_storage">Storage Type</label>
                                                            <select name="type_storage" id="type_storage" required class="form-control"style="width: 40%;">
                                                                <option value="amazon">Amazon</option>
                                                                <option value="ftp">FTP</option>
                                                            </select>
                                                        </div>

                                                        <div id="ftpConfig" style="display: none;" class="mt-3">
                                                            <div class="form-group mb-3">
                                                                <label for="ftp_host">FTP Host</label>
                                                                <input type="text" name="ftp_host" id="ftp_host" class="form-control">
                                                            </div>
                                                            <div class="form-group mb-3">
                                                                <label for="ftp_port">FTP Port</label>
                                                                <input type="number" name="ftp_port" id="ftp_port" class="form-control">
                                                            </div>
                                                            <div class="form-group mb-3">
                                                                <label for="ftp_username">FTP Username</label>
                                                                <input type="text" name="ftp_username" id="ftp_username" class="form-control">
                                                            </div>
                                                            <div class="form-group mb-3">
                                                                <label for="ftp_password">FTP Password</label>
                                                                <input type="password" name="ftp_password" id="ftp_password" class="form-control">
                                                            </div>
                                                        </div>

                                                        <button type="submit" class="btn btn-primary">Save</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endsection

    @push('after-scripts')
    <script src="{{ asset('js/backend/settings.js') }}"></script>
    @endpush
    @push('before-styles')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    @endpush
