<?php
$darkModeSettings = \App\Models\UserMeta::Preferences(auth()->user(), \App\Models\UserMeta::DARK_MODE);

$dark = isset($darkModeSettings) && isset($darkModeSettings['dark_mode']) && $darkModeSettings['dark_mode'] == "YES" ? "dark-" : "";
?>

<div class="sidebar-x">

  <div class="sb-item-list">
    <a class="sb-item" href="<?php echo e(route('admin.dashboard')); ?>">
      <img src="<?php echo e(asset('img/frontend/sidebar/'.$dark.'dashboard.svg')); ?>" class="img-fluid sb-img  parent-sub " />
    
      <span class="sb-span"> <?php echo app('translator')->get('menus.backend.sidebar.dashboard'); ?></span>
  </a>
<?php if($logged_in_user->hasPermission('view_category')): ?>
  <a class="sb-item" href="<?php echo e(route('admin.categories.index')); ?>">
    <img src="<?php echo e(asset('img/frontend/sidebar/'.$dark.'home.svg')); ?>" class="img-fluid sb-img  parent-sub " />
  
    <span class="sb-span"> <?php echo app('translator')->get('labels.general.main_page'); ?></span>
</a>
<?php endif; ?>
<?php if($logged_in_user->hasPermissions(['view_role_management','view_permission_management','view_user_management'],false)): ?>
<div class="sb-item sb-menu ">
  <img src ="<?php echo e(asset('img/frontend/sidebar/'.$dark.'access.svg')); ?>"class="img-fluid sb-img  parent-sub" />
  <span class="sb-span">
    <?php echo app('translator')->get('menus.backend.sidebar.system'); ?>
  </span>
   
  <div class="level-1 main-item">
      <div class="menu-container">
         <div class="sb-item">
              <span class="sb-text "> <?php echo app('translator')->get('menus.backend.sidebar.system'); ?></span>
          </div>
          <a href="<?php echo e(route('admin.auth.user.index')); ?>" class="sb-item ">
              <img src ="<?php echo e(asset('img/frontend/sidebar/users.svg')); ?>?p"
                  class="img-fluid submenu-img" /><span
                  class="sb-text"><?php echo app('translator')->get('labels.backend.access.users.management'); ?></span>
          </a>
        
          <a href="<?php echo e(route('admin.auth.role.index')); ?>" class="sb-item ">
            <img src ="<?php echo e(asset('img/frontend/sidebar/roles.svg')); ?>?p"
                class="img-fluid submenu-img" /><span
                class="sb-text"><?php echo app('translator')->get('labels.backend.access.roles.management'); ?></span>
        </a>
     
      </div>
  </div>
</div>
<?php endif; ?>
 <?php if($logged_in_user->hasPermission('view_document_report')): ?>
<a class="sb-item" href="<?php echo e(route('admin.documents.filter')); ?>">
  <img src="<?php echo e(asset('img/frontend/sidebar/'.$dark.'documents.svg')); ?>" class="img-fluid sb-img  parent-sub " />

  <span class="sb-span"><?php echo app('translator')->get('menus.backend.sidebar.documentfilter'); ?></span>
</a>
<?php endif; ?>
<?php if($logged_in_user->hasPermission('view_log_filter')): ?>
<a class="sb-item" href="<?php echo e(route('admin.logs.filter')); ?>">
  <img src="<?php echo e(asset('img/frontend/sidebar/'.$dark.'logs.svg')); ?>" class="img-fluid sb-img  parent-sub " />

  <span class="sb-span"><?php echo app('translator')->get('menus.backend.sidebar.logs'); ?></span>
</a>
<?php endif; ?>
<a class="sb-item" href="<?php echo e(route('admin.auth.settings')); ?>">
  <img src="<?php echo e(asset('img/frontend/sidebar/'.$dark.'setting.svg')); ?>" class="img-fluid sb-img  parent-sub " />

  <span class="sb-span"><?php echo app('translator')->get('menus.backend.sidebar.settings'); ?></span>
</a>
  


  </div>
</div>

<?php /**PATH D:\mbl\doc\resources\views/backend/includes/sidebar.blade.php ENDPATH**/ ?>