

<?php $__env->startSection('title', __('labels.backend.access.users.management') . ' | ' . __('labels.backend.access.users.create')); ?>

<?php $__env->startSection('breadcrumb-links'); ?>
<?php echo $__env->make('backend.auth.user.includes.breadcrumb-links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo e(Form::open(['route' => 'admin.auth.user.store', 'class' => 'form-horizontal create_user', 'role' => 'form', 'method' => 'post'])); ?>


<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    <?php echo app('translator')->get('labels.backend.access.users.management'); ?>
                    <small class="text-muted"><?php echo app('translator')->get('labels.backend.access.users.create'); ?></small>
                </h4>
            </div>
            <!--col-->
        </div>
        <!--row-->

        <hr>

        <div class="row mt-4 mb-4">
            <div class="col">
                <div class="form-group row">
                    <?php echo e(Form::label('first_name', __('validation.attributes.backend.access.users.first_name'), [ 'class'=>'col-md-2 form-control-label'])); ?>


                    <div class="col-md-10">
                        <?php echo e(Form::text('first_name', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.access.users.first_name'), 'required' => 'required'])); ?>

                    </div>
                    <!--col-->
                </div>
                <!--form-group-->

                <div class="form-group row">
                    <?php echo e(Form::label('last_name', __('validation.attributes.backend.access.users.last_name'), [ 'class'=>'col-md-2 form-control-label'])); ?>


                    <div class="col-md-10">
                        <?php echo e(Form::text('last_name', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.access.users.last_name'), 'required' => 'required'])); ?>

                    </div>
                    <!--col-->
                </div>
                <!--form-group-->

                <div class="form-group row">
                    <?php echo e(Form::label('email', __('validation.attributes.backend.access.users.email'), [ 'class'=>'col-md-2 form-control-label'])); ?>


                    <div class="col-md-10">
                        <?php echo e(Form::text('email', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.access.users.email'), 'required' => 'required'])); ?>

                    </div>
                    <!--col-->
                </div>
                <!--form-group-->

                <div class="form-group row">
                    <?php echo e(Form::label('password', __('validation.attributes.backend.access.users.password'), [ 'class'=>'col-md-2 form-control-label'])); ?>


                    <div class="col-md-10">
                        <?php echo e(Form::password('password', ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.access.users.password'), 'required' => 'required'])); ?>

                    </div>
                    <!--col-->
                </div>
                <!--form-group-->

                <div class="form-group row">
                    <?php echo e(html()->label(__('validation.attributes.backend.access.users.password_confirmation'))->class('col-md-2 form-control-label')->for('password_confirmation')); ?>


                    <div class="col-md-10">
                        <?php echo e(html()->password('password_confirmation')
                                    ->class('form-control')
                                    ->placeholder(__('validation.attributes.backend.access.users.password_confirmation'))
                                    ->required()); ?>

                    </div>
                    <!--col-->
                </div>
                <!--form-group-->

                <div class="form-group row">
                    <?php echo e(Form::label('status', trans('validation.attributes.backend.access.users.active'), ['class' => 'col-md-2 control-label'])); ?>

                    <div class="col-md-10">
                        <?php echo e(Form::checkbox('status', '1', true)); ?>

                    </div>
                </div>
                <!--form control-->

                <div class="form-group row">
                    <?php echo e(Form::label('confirmed', trans('validation.attributes.backend.access.users.confirmed'), ['class' => 'col-md-2 control-label'])); ?>

                    <div class="col-md-10">
                        <?php echo e(Form::checkbox('confirmed', '1', true)); ?>

                    </div>
                </div>
                <!--form control-->



                <?php if(! config('access.users.requires_approval')): ?>
                <div class="form-group row">
                    <label class="col-md-2 control-label"><?php echo e(trans('validation.attributes.backend.access.users.send_confirmation_email')); ?><br />
                        <small><?php echo e(trans('strings.backend.access.users.if_confirmed_off')); ?></small>
                    </label>

                    <div class="col-md-10">
                        <?php echo e(Form::checkbox('confirmation_email', '1')); ?>

                    </div>
                    <!--col-lg-1-->
                </div>
                <!--form control-->
                <?php endif; ?>

                <div class="form-group row">
                    <?php echo e(Form::label('status', trans('validation.attributes.backend.access.users.associated_roles'), ['class' => 'col-md-2 control-label'])); ?>

                    <div class="col-md-8">
                        <?php if(count($roles) > 0): ?>
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <label for="role-<?php echo e($role->id); ?>" class="control">
                            <input type="radio" value="<?php echo e($role->id); ?>" name="assignees_roles[]" <?php echo e($role->id == 3 ? 'checked' : ''); ?> id="role-<?php echo e($role->id); ?>" class="get-role-for-permissions" /> &nbsp;&nbsp;<?php echo $role->name; ?>

                        </label>
                        <!--permission list-->
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <?php echo e(trans('labels.backend.access.users.no_roles')); ?>

                        <?php endif; ?>
                    </div>
                </div>
                <!--form-group-->

                <div class="form-group row">
                    <?php echo e(Form::label('associated-permissions', trans('validation.attributes.backend.access.roles.associated_permissions'), ['class' => 'col-md-2 control-label'])); ?>

                    <div class="col-md-10 search-permission">
                        <div id="available-permissions">
                            <div class="row">
                                <div class="col-md-10">
                                    <input type="text" class="form-control search-button" placeholder="Search..." />
                                </div>
                                <div class="col-md-2 mt-2">
                                    <div>
                                        <input type="checkbox" id="select-all" /> <label for="select-all">Select All</label>
                                    </div>
                                </div>
                            </div>
                            <div class="get-available-permissions">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group row">
                    <?php echo e(Form::label('associated-categories', trans('validation.attributes.backend.access.users.associated_categories'), ['class' => 'col-md-2 control-label'])); ?>

                    <div class="col-md-10 ">

                    <input type="text" class="form-control search-button-tree" placeholder="Search..." />

                    <div id="treeDemo">
                        <ul>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $root): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($root->name); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                </div>
            </div>
            <!--col-->
        </div>
        <!--row-->
    </div>
    <!--card-body-->

    <?php echo $__env->make('backend.components.footer-buttons', [ 'cancelRoute' => 'admin.auth.user.index' ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<!--card-->
<?php echo e(Form::close()); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('before-styles'); ?>
    <meta name="root-url" content="<?php echo e(route('admin.categories.tree')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('vendors/vakata-jstree-b3135cf/dist/themes/default/style.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <script src="<?php echo e(asset('vendors/vakata-jstree-b3135cf/dist/jstree.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('pagescript'); ?>
<script>
    FTX.Utils.documentReady(function() {
        FTX.Users.edit.selectors.getPremissionURL = "<?php echo e(route('admin.get.permission')); ?>";
        FTX.Users.edit.init("create");
    });
</script>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('after-styles'); ?>

<?php echo e(style(asset('css/tree.css'))); ?>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\mbl\doc\resources\views/backend/auth/user/create.blade.php ENDPATH**/ ?>