<?php
$darkModeSettings = \App\Models\UserMeta::Preferences(auth()->user(), \App\Models\UserMeta::DARK_MODE);

$dark_mode = isset($darkModeSettings) && isset($darkModeSettings['dark_mode']) && $darkModeSettings['dark_mode'] == "YES" ? true : false;
$font_size = \App\Models\UserMeta::where("user_id", auth()->id())->where("name", \App\Models\UserMeta::THEME_FONT)->first()?->value;
?>
<!DOCTYPE html>
<?php if (\Illuminate\Support\Facades\Blade::check('langrtl')): ?>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="rtl">
<?php else: ?>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<?php endif; ?>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', app_name()); ?></title>
    <meta name="description" content="<?php echo $__env->yieldContent('meta_description', 'Laravel Starter'); ?>">
    <meta name="author" content="<?php echo $__env->yieldContent('meta_author', 'FasTrax Infotech'); ?>">
    <meta name="view" content="<?php echo e(App\Models\Category::VIEW); ?>">
    <meta name="edit" content="<?php echo e(App\Models\Category::EDIT); ?>">
    <meta name="delete" content="<?php echo e(App\Models\Category::DELETE); ?>">
    <meta name="create" content="<?php echo e(App\Models\Category::CREATE); ?>">
    <meta name="share" content="<?php echo e(App\Models\Category::SHARE); ?>">
     <meta id="mode-style-url" content="<?php echo e(asset('css/dark-mode.css')); ?>?v7.221.367">
   

    <?php echo $__env->yieldContent('meta'); ?>

    
    <?php echo $__env->yieldPushContent('before-styles'); ?>

    <!-- Check if the language is set to RTL, so apply the RTL layouts -->
    <!-- Otherwise apply the normal LTR layouts -->
    <?php echo e(style(mix('css/backend.css'))); ?>


    <link rel="stylesheet" href="https://netdna.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/boxicons/2.1.4/css/animations.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/boxicons/2.1.4/css/boxicons.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/boxicons/2.1.4/css/transformations.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/backend.css')); ?>?v2">
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>?v2">
     <link rel="stylesheet" href="<?php echo e(asset('css/sidebarx.css')); ?>?v3">

<?php if($dark_mode): ?>
    <link id="dark-style"  href="<?php echo e(asset('css/dark-mode.css')); ?>?v7.221.367"  rel="stylesheet">
<?php endif; ?>
     <?php echo $__env->yieldPushContent('after-styles'); ?>
    <style>
        .hidden {
            display: none !important;
        }
    </style>
</head>



<body class="app <?php if($dark_mode): ?> dark-theme <?php endif; ?> header-fixed sidebar-fixed aside-menu-off-canvas sidebar-lg-show" style="font-size:<?php echo e($font_size ?? '14px'); ?> ">
  
    <?php echo $__env->make('backend.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="wrapper sidebar-collapse app-body" >

        <?php echo $__env->make('backend.includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <main class="main">
            <?php echo $__env->make('includes.partials.read-only', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('includes.partials.logged-in-as', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo Breadcrumbs::render(); ?>


            <div class="container-fluid pt-3">
                <div class="animated fadeIn">
                    <div class="content-header">
                        <?php echo $__env->yieldContent('page-header'); ?>
                    </div>
                    <!--content-header-->

                    <?php echo $__env->make('includes.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
                <!--animated-->
            </div>
            <!--container-fluid-->
        </main>
        <!--main-->

        <?php echo $__env->make('backend.includes.partials.theme_sidebar', [
  'dark_mode' => $dark_mode,
  'font_size' => $font_size,
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('backend.includes.aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
    </div>
    <!--app-body-->

    <?php echo $__env->make('backend.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Scripts -->
    <?php echo $__env->yieldPushContent('before-scripts'); ?>
    <?php echo script(mix('js/manifest.js')); ?>

    <?php echo script(mix('js/vendor.js')); ?>

    <?php echo script(mix('js/backend.js')); ?>

    <script src="<?php echo e(asset('/js/tinymce/tinymce.min.js')); ?>"></script>
    <?php echo script(asset('js/backend/common.js')); ?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-cookie/1.4.1/jquery.cookie.min.js"></script>
    <?php echo script(asset('js/backend/app.js'), [], null,'532024'); ?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/boxicons/2.1.4/dist/boxicons.js"></script>

    <?php if(isset($js)): ?>
    <?php $__currentLoopData = $js; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php echo script(asset('js/backend/'. $j. '.js'), [], null,'2422024'); ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<script>
    $(".reset-default").on("click", function () {
  var url = $(this).attr("data-url");
  let fontSize = "14px";
  $("body").css("font-size", fontSize);
  $(".slider-point").each(function(){
    $(this).removeClass("active");
    if ($(this).data("value") == fontSize){
      $(this).addClass("active");
    }
  });
  if ($.fn.DataTable.isDataTable(".datatable-full")) {
    table.destroy();  // تدمير الجدول الحالي
  }

  table = $(".datatable-full").DataTable(tableOptions);

  $(".change-mode").each(function(){
    $(this).removeClass("active");
    if ($(this).data("mode") == "light"){
      $(this).addClass("active");
    }
  });
  $("body").removeClass("dark-theme");
    $("#dark-style").remove();
    $('.dynamic-chart,.chart').removeClass("highcharts-dark");
  $('img.parent-sub').each(function () {
    let currentSrc = $(this).attr('src').split('/');
    let fileName = currentSrc.pop().replace("dark-", "");;
    let path = currentSrc.join('/');
    let newImg = fileName;
    $(this).attr('src', path + "/" + newImg);
  });
  $.get(url)
    .done(function (data) {

    }).fail(function (xhr) {
      alert(xhr.responseJSON.message);
    });

});
$(".slider-point").on("click", function () {
    $(".slider-point").removeClass("active");
    $(this).addClass("active");
    console.log("ewew");
    let fontSize = $(this).data("value");
    let url = $(this).parent().data("url");
      console.log(url);
    $("body").css("font-size", fontSize);
    $("table").find("td,th").each(function () {
      $(this).removeClass("sticky-column");
      $(this).removeClass("last-sticky");
      $(this).css('left', '0px');
    });
    if ($.fn.DataTable.isDataTable(".datatable-full")) {
      table.destroy();  // تدمير الجدول الحالي
      table = $(".datatable-full").DataTable(tableOptions);
    }



    $.post(url, { _token: $('meta[name="csrf-token"]').attr('content'), font: fontSize }).done(function () {
    }).fail(function () {
    });
  });
$(".change-mode").on("click", function () {
  var url = $(this).attr("data-url");
  var mode = $(this).attr("data-mode");
  $(".change-mode").removeClass("active");
  $(this).addClass("active");
  if (mode == "dark") {
    var styleUrl = $("#mode-style-url").attr("content");
    if($("#dark-style").length == 0){
    $("head").append('<link id="dark-style"  href="' + styleUrl + '"  rel="stylesheet">');
    }
    $('.dynamic-chart,.chart').addClass("highcharts-dark");
    $("body").addClass("dark-theme");
  } else {
    $("#dark-style").remove();

    $('.dynamic-chart,.chart').removeClass("highcharts-dark");
    $("body").removeClass("dark-theme");
  }

  $('img.parent-sub').each(function () {
    let currentSrc = $(this).attr('src').split('/');
    let fileName = currentSrc.pop().replace("dark-", "");;
    let path = currentSrc.join('/');
    let newImg = mode == "dark" ? "dark-" + fileName : fileName;
    $(this).attr('src', path + "/" + newImg);
  });
  $.get(url)
    .done(function (data) {

    }).fail(function (xhr) {
      alert(xhr.responseJSON.message);
    });

});

</script>
    <?php echo $__env->yieldPushContent('after-scripts'); ?>

    <?php echo $__env->yieldContent('pagescript'); ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

  </body>

</html>
<?php /**PATH D:\mbl\doc\resources\views/backend/layouts/app.blade.php ENDPATH**/ ?>